@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP rule with specific IP or IP range in CIDR format.
 * @property action The action of IP ACL rule.
 * @property iPAddressOrRange Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
 */
public data class IPRuleResponse(
    public val action: String? = null,
    public val iPAddressOrRange: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.IPRuleResponse):
            IPRuleResponse = IPRuleResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            iPAddressOrRange = javaType.iPAddressOrRange(),
        )
    }
}
