@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Identity for the resource.
 * @property principalId The principal ID of resource identity.
 * @property tenantId The tenant ID of resource.
 * @property type The identity type.
 * @property userAssignedIdentities Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage account. The key is the ARM resource identifier of the identity. Only 1 User Assigned identity is permitted here.
 */
public data class IdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String,
    public val userAssignedIdentities: Map<String, UserAssignedIdentityResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.IdentityResponse):
            IdentityResponse = IdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.storage.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
