@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * This property enables and defines account-level immutability. Enabling the feature auto-enables Blob Versioning.
 * @property enabled A boolean flag which enables account-level immutability. All the containers under such an account have object-level immutability enabled by default.
 * @property immutabilityPolicy Specifies the default account-level immutability policy which is inherited and applied to objects that do not possess an explicit immutability policy at the object level. The object-level immutability policy has higher precedence than the container-level immutability policy, which has a higher precedence than the account-level immutability policy.
 */
public data class ImmutableStorageAccountResponse(
    public val enabled: Boolean? = null,
    public val immutabilityPolicy: AccountImmutabilityPolicyPropertiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ImmutableStorageAccountResponse):
            ImmutableStorageAccountResponse = ImmutableStorageAccountResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            immutabilityPolicy = javaType.immutabilityPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.AccountImmutabilityPolicyPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
