@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The response from the ListKeys operation.
 * @property keys Gets the list of storage account keys and their properties for the specified storage account.
 */
public data class ListStorageAccountKeysResult(
    public val keys: List<StorageAccountKeyResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ListStorageAccountKeysResult):
            ListStorageAccountKeysResult = ListStorageAccountKeysResult(
            keys = javaType.keys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.StorageAccountKeyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
