@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Management policy action for base blob.
 * @property delete The function to delete the blob
 * @property enableAutoTierToHotFromCool This property enables auto tiering of a blob from cool to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
 * @property tierToArchive The function to tier blobs to archive storage.
 * @property tierToCold The function to tier blobs to cold storage.
 * @property tierToCool The function to tier blobs to cool storage.
 * @property tierToHot The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
 */
public data class ManagementPolicyBaseBlobResponse(
    public val delete: DateAfterModificationResponse? = null,
    public val enableAutoTierToHotFromCool: Boolean? = null,
    public val tierToArchive: DateAfterModificationResponse? = null,
    public val tierToCold: DateAfterModificationResponse? = null,
    public val tierToCool: DateAfterModificationResponse? = null,
    public val tierToHot: DateAfterModificationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ManagementPolicyBaseBlobResponse):
            ManagementPolicyBaseBlobResponse = ManagementPolicyBaseBlobResponse(
            delete = javaType.delete().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DateAfterModificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enableAutoTierToHotFromCool = javaType.enableAutoTierToHotFromCool().map({ args0 ->
                args0
            }).orElse(null),
            tierToArchive = javaType.tierToArchive().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DateAfterModificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tierToCold = javaType.tierToCold().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DateAfterModificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tierToCool = javaType.tierToCool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DateAfterModificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tierToHot = javaType.tierToHot().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DateAfterModificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
