@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Object to set Table Access Policy.
 * @property accessPolicy Access policy
 * @property id unique-64-character-value of the stored access policy.
 */
public data class TableSignedIdentifierResponse(
    public val accessPolicy: TableAccessPolicyResponse? = null,
    public val id: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.TableSignedIdentifierResponse):
            TableSignedIdentifierResponse = TableSignedIdentifierResponse(
            accessPolicy = javaType.accessPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.TableAccessPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
        )
    }
}
