@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Blob index tag based filtering for blob objects
 * @property name This is the filter tag name, it can have 1 - 128 characters
 * @property op This is the comparison operator which is used for object comparison and filtering. Only == (equality operator) is currently supported
 * @property value This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
 */
public data class TagFilterResponse(
    public val name: String,
    public val op: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.TagFilterResponse):
            TagFilterResponse = TagFilterResponse(
            name = javaType.name(),
            op = javaType.op(),
            `value` = javaType.`value`(),
        )
    }
}
