@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin

import com.pulumi.azurenative.storageactions.StorageTaskArgs.builder
import com.pulumi.azurenative.storageactions.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.storageactions.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.storageactions.kotlin.inputs.StorageTaskActionArgs
import com.pulumi.azurenative.storageactions.kotlin.inputs.StorageTaskActionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents Storage Task.
 * Azure REST API version: 2023-01-01.
 * ## Example Usage
 * ### PutStorageTask
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageTask = new AzureNative.StorageActions.StorageTask("storageTask", new()
 *     {
 *         Action = new AzureNative.StorageActions.Inputs.StorageTaskActionArgs
 *         {
 *             Else = new AzureNative.StorageActions.Inputs.ElseConditionArgs
 *             {
 *                 Operations = new[]
 *                 {
 *                     new AzureNative.StorageActions.Inputs.StorageTaskOperationArgs
 *                     {
 *                         Name = "DeleteBlob",
 *                         OnFailure = AzureNative.StorageActions.OnFailure.@Break,
 *                         OnSuccess = AzureNative.StorageActions.OnSuccess.@Continue,
 *                     },
 *                 },
 *             },
 *             If = new AzureNative.StorageActions.Inputs.IfConditionArgs
 *             {
 *                 Condition = "[[equals(AccessTier, 'Cool')]]",
 *                 Operations = new[]
 *                 {
 *                     new AzureNative.StorageActions.Inputs.StorageTaskOperationArgs
 *                     {
 *                         Name = "SetBlobTier",
 *                         OnFailure = AzureNative.StorageActions.OnFailure.@Break,
 *                         OnSuccess = AzureNative.StorageActions.OnSuccess.@Continue,
 *                         Parameters =
 *                         {
 *                             { "tier", "Hot" },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Description = "My Storage task",
 *         Enabled = true,
 *         Location = "westus",
 *         ResourceGroupName = "res4228",
 *         StorageTaskName = "mytask1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storageactions/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storageactions.NewStorageTask(ctx, "storageTask", &storageactions.StorageTaskArgs{
 * Action: storageactions.StorageTaskActionResponse{
 * Else: interface{}{
 * Operations: storageactions.StorageTaskOperationArray{
 * &storageactions.StorageTaskOperationArgs{
 * Name: pulumi.String("DeleteBlob"),
 * OnFailure: storageactions.OnFailureBreak,
 * OnSuccess: storageactions.OnSuccessContinue,
 * },
 * },
 * },
 * If: interface{}{
 * Condition: pulumi.String("[[equals(AccessTier, 'Cool')]]"),
 * Operations: storageactions.StorageTaskOperationArray{
 * &storageactions.StorageTaskOperationArgs{
 * Name: pulumi.String("SetBlobTier"),
 * OnFailure: storageactions.OnFailureBreak,
 * OnSuccess: storageactions.OnSuccessContinue,
 * Parameters: pulumi.StringMap{
 * "tier": pulumi.String("Hot"),
 * },
 * },
 * },
 * },
 * },
 * Description: pulumi.String("My Storage task"),
 * Enabled: pulumi.Bool(true),
 * Location: pulumi.String("westus"),
 * ResourceGroupName: pulumi.String("res4228"),
 * StorageTaskName: pulumi.String("mytask1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storageactions.StorageTask;
 * import com.pulumi.azurenative.storageactions.StorageTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageTask = new StorageTask("storageTask", StorageTaskArgs.builder()
 *             .action(Map.ofEntries(
 *                 Map.entry("else", Map.of("operations", Map.ofEntries(
 *                     Map.entry("name", "DeleteBlob"),
 *                     Map.entry("onFailure", "break"),
 *                     Map.entry("onSuccess", "continue")
 *                 ))),
 *                 Map.entry("if", Map.ofEntries(
 *                     Map.entry("condition", "[[equals(AccessTier, 'Cool')]]"),
 *                     Map.entry("operations", Map.ofEntries(
 *                         Map.entry("name", "SetBlobTier"),
 *                         Map.entry("onFailure", "break"),
 *                         Map.entry("onSuccess", "continue"),
 *                         Map.entry("parameters", Map.of("tier", "Hot"))
 *                     ))
 *                 ))
 *             ))
 *             .description("My Storage task")
 *             .enabled(true)
 *             .location("westus")
 *             .resourceGroupName("res4228")
 *             .storageTaskName("mytask1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storageactions:StorageTask mytask1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}
 * ```
 * @property action The storage task action that is executed
 * @property description Text that describes the purpose of the storage task
 * @property enabled Storage Task is enabled when set to true and disabled when set to false
 * @property identity The managed service identity of the resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageTaskName The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only.
 * @property tags Resource tags.
 */
public data class StorageTaskArgs(
    public val action: Output<StorageTaskActionArgs>? = null,
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageTaskName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storageactions.StorageTaskArgs> {
    override fun toJava(): com.pulumi.azurenative.storageactions.StorageTaskArgs =
        com.pulumi.azurenative.storageactions.StorageTaskArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageTaskName(storageTaskName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StorageTaskArgs].
 */
@PulumiTagMarker
public class StorageTaskArgsBuilder internal constructor() {
    private var action: Output<StorageTaskActionArgs>? = null

    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageTaskName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The storage task action that is executed
     */
    @JvmName("rbdtngsymdnxkmsj")
    public suspend fun action(`value`: Output<StorageTaskActionArgs>) {
        this.action = value
    }

    /**
     * @param value Text that describes the purpose of the storage task
     */
    @JvmName("jbpmrbpilrqpwwbd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Storage Task is enabled when set to true and disabled when set to false
     */
    @JvmName("jacerrlmplnfxope")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The managed service identity of the resource.
     */
    @JvmName("ualapfrjsxunspyl")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xllukfweafbjniaj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wylkqiddgeynisnw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("iquqjjsquplfbacn")
    public suspend fun storageTaskName(`value`: Output<String>) {
        this.storageTaskName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("byjsluthdxioolwx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The storage task action that is executed
     */
    @JvmName("cvovhbwnvmtobfbo")
    public suspend fun action(`value`: StorageTaskActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The storage task action that is executed
     */
    @JvmName("hlacwptfsgtskkkj")
    public suspend fun action(argument: suspend StorageTaskActionArgsBuilder.() -> Unit) {
        val toBeMapped = StorageTaskActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Text that describes the purpose of the storage task
     */
    @JvmName("dtrovtvdwkowqqpp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Storage Task is enabled when set to true and disabled when set to false
     */
    @JvmName("ethgmsguwiuitehk")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The managed service identity of the resource.
     */
    @JvmName("axaedwnaxaikrutp")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed service identity of the resource.
     */
    @JvmName("mrkkpkltcnatfqib")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fyumvxfmporrifwi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lkbmbvrmyawuavke")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("uktvcnagtiayfbpm")
    public suspend fun storageTaskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageTaskName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dfxectsqgrlousoq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hlreagsbdonuxasg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StorageTaskArgs = StorageTaskArgs(
        action = action,
        description = description,
        enabled = enabled,
        identity = identity,
        location = location,
        resourceGroupName = resourceGroupName,
        storageTaskName = storageTaskName,
        tags = tags,
    )
}
