@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin

import com.pulumi.azurenative.storageactions.StorageactionsFunctions.getStorageTaskPlain
import com.pulumi.azurenative.storageactions.kotlin.inputs.GetStorageTaskPlainArgs
import com.pulumi.azurenative.storageactions.kotlin.inputs.GetStorageTaskPlainArgsBuilder
import com.pulumi.azurenative.storageactions.kotlin.outputs.GetStorageTaskResult
import com.pulumi.azurenative.storageactions.kotlin.outputs.GetStorageTaskResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object StorageactionsFunctions {
    /**
     * Get the storage task properties
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return Represents Storage Task.
     */
    public suspend fun getStorageTask(argument: GetStorageTaskPlainArgs): GetStorageTaskResult =
        toKotlin(getStorageTaskPlain(argument.toJava()).await())

    /**
     * @see [getStorageTask].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param storageTaskName The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only.
     * @return Represents Storage Task.
     */
    public suspend fun getStorageTask(resourceGroupName: String, storageTaskName: String):
        GetStorageTaskResult {
        val argument = GetStorageTaskPlainArgs(
            resourceGroupName = resourceGroupName,
            storageTaskName = storageTaskName,
        )
        return toKotlin(getStorageTaskPlain(argument.toJava()).await())
    }

    /**
     * @see [getStorageTask].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storageactions&#46;kotlin&#46;inputs&#46;GetStorageTaskPlainArgs].
     * @return Represents Storage Task.
     */
    public suspend fun getStorageTask(argument: suspend GetStorageTaskPlainArgsBuilder.() -> Unit):
        GetStorageTaskResult {
        val builder = GetStorageTaskPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getStorageTaskPlain(builtArgument.toJava()).await())
    }
}
