@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin.inputs

import com.pulumi.azurenative.storageactions.inputs.GetStorageTaskPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageTaskName The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only.
 */
public data class GetStorageTaskPlainArgs(
    public val resourceGroupName: String,
    public val storageTaskName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storageactions.inputs.GetStorageTaskPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storageactions.inputs.GetStorageTaskPlainArgs =
        com.pulumi.azurenative.storageactions.inputs.GetStorageTaskPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageTaskName(storageTaskName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageTaskPlainArgs].
 */
@PulumiTagMarker
public class GetStorageTaskPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var storageTaskName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dmjbewddkhquyubb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("bbnuhpuectwoexcl")
    public suspend fun storageTaskName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageTaskName = mapped
    }

    internal fun build(): GetStorageTaskPlainArgs = GetStorageTaskPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageTaskName = storageTaskName ?: throw PulumiNullFieldException("storageTaskName"),
    )
}
