@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin.inputs

import com.pulumi.azurenative.storageactions.inputs.StorageTaskActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The storage task action represents conditional statements and operations to be performed on target objects.
 * @property else The else block of storage task operation
 * @property if The if block of storage task operation
 */
public data class StorageTaskActionArgs(
    public val `else`: Output<ElseConditionArgs>? = null,
    public val `if`: Output<IfConditionArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.storageactions.inputs.StorageTaskActionArgs> {
    override fun toJava(): com.pulumi.azurenative.storageactions.inputs.StorageTaskActionArgs =
        com.pulumi.azurenative.storageactions.inputs.StorageTaskActionArgs.builder()
            .else_(`else`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .if_(`if`.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StorageTaskActionArgs].
 */
@PulumiTagMarker
public class StorageTaskActionArgsBuilder internal constructor() {
    private var `else`: Output<ElseConditionArgs>? = null

    private var `if`: Output<IfConditionArgs>? = null

    /**
     * @param value The else block of storage task operation
     */
    @JvmName("gueiagrmypjwwitx")
    public suspend fun `else`(`value`: Output<ElseConditionArgs>) {
        this.`else` = value
    }

    /**
     * @param value The if block of storage task operation
     */
    @JvmName("pylegtbywagndewq")
    public suspend fun `if`(`value`: Output<IfConditionArgs>) {
        this.`if` = value
    }

    /**
     * @param value The else block of storage task operation
     */
    @JvmName("taounfqqbkguckqt")
    public suspend fun `else`(`value`: ElseConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`else` = mapped
    }

    /**
     * @param argument The else block of storage task operation
     */
    @JvmName("tykljuarvmrtgeti")
    public suspend fun `else`(argument: suspend ElseConditionArgsBuilder.() -> Unit) {
        val toBeMapped = ElseConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.`else` = mapped
    }

    /**
     * @param value The if block of storage task operation
     */
    @JvmName("gwoawmtpfyaetlhk")
    public suspend fun `if`(`value`: IfConditionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`if` = mapped
    }

    /**
     * @param argument The if block of storage task operation
     */
    @JvmName("ilenypkvaggqucwv")
    public suspend fun `if`(argument: suspend IfConditionArgsBuilder.() -> Unit) {
        val toBeMapped = IfConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.`if` = mapped
    }

    internal fun build(): StorageTaskActionArgs = StorageTaskActionArgs(
        `else` = `else`,
        `if` = `if` ?: throw PulumiNullFieldException("if"),
    )
}
