@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin

import com.pulumi.azurenative.storagecache.CacheArgs.builder
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheDirectorySettingsArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheDirectorySettingsArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheEncryptionSettingsArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheEncryptionSettingsArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheIdentityArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheIdentityArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheNetworkSettingsArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheNetworkSettingsArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheSecuritySettingsArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheSecuritySettingsArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheSkuArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheSkuArgsBuilder
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheUpgradeSettingsArgs
import com.pulumi.azurenative.storagecache.kotlin.inputs.CacheUpgradeSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A cache instance. Follows Azure Resource Manager standards: https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2020-10-01, 2021-03-01, 2023-03-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### Caches_CreateOrUpdate_ldap_only
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cache = new AzureNative.StorageCache.Cache("cache", new()
 *     {
 *         CacheName = "sc1",
 *         CacheSizeGB = 3072,
 *         DirectoryServicesSettings = new AzureNative.StorageCache.Inputs.CacheDirectorySettingsArgs
 *         {
 *             UsernameDownload = new AzureNative.StorageCache.Inputs.CacheUsernameDownloadSettingsArgs
 *             {
 *                 Credentials = new AzureNative.StorageCache.Inputs.CacheUsernameDownloadSettingsCredentialsArgs
 *                 {
 *                     BindDn = "cn=ldapadmin,dc=contosoad,dc=contoso,dc=local",
 *                     BindPassword = "<bindPassword>",
 *                 },
 *                 ExtendedGroups = true,
 *                 LdapBaseDN = "dc=contosoad,dc=contoso,dc=local",
 *                 LdapServer = "192.0.2.12",
 *                 UsernameSource = "LDAP",
 *             },
 *         },
 *         EncryptionSettings = new AzureNative.StorageCache.Inputs.CacheEncryptionSettingsArgs
 *         {
 *             KeyEncryptionKey = new AzureNative.StorageCache.Inputs.KeyVaultKeyReferenceArgs
 *             {
 *                 KeyUrl = "https://keyvault-cmk.vault.azure.net/keys/key2048/test",
 *                 SourceVault = new AzureNative.StorageCache.Inputs.KeyVaultKeyReferenceSourceVaultArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.KeyVault/vaults/keyvault-cmk",
 *                 },
 *             },
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "scgroup",
 *         SecuritySettings = new AzureNative.StorageCache.Inputs.CacheSecuritySettingsArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.StorageCache.Inputs.NfsAccessPolicyArgs
 *                 {
 *                     AccessRules = new[]
 *                     {
 *                         new AzureNative.StorageCache.Inputs.NfsAccessRuleArgs
 *                         {
 *                             Access = "rw",
 *                             RootSquash = false,
 *                             Scope = "default",
 *                             SubmountAccess = true,
 *                             Suid = false,
 *                         },
 *                     },
 *                     Name = "default",
 *                 },
 *             },
 *         },
 *         Sku = new AzureNative.StorageCache.Inputs.CacheSkuArgs
 *         {
 *             Name = "Standard_2G",
 *         },
 *         Subnet = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Network/virtualNetworks/scvnet/subnets/sub1",
 *         Tags =
 *         {
 *             { "Dept", "Contoso" },
 *         },
 *         UpgradeSettings = new AzureNative.StorageCache.Inputs.CacheUpgradeSettingsArgs
 *         {
 *             ScheduledTime = "2022-04-26T18:25:43.511Z",
 *             UpgradeScheduleEnabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagecache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storagecache.NewCache(ctx, "cache", &storagecache.CacheArgs{
 * CacheName: pulumi.String("sc1"),
 * CacheSizeGB: pulumi.Int(3072),
 * DirectoryServicesSettings: storagecache.CacheDirectorySettingsResponse{
 * UsernameDownload: interface{}{
 * Credentials: &storagecache.CacheUsernameDownloadSettingsCredentialsArgs{
 * BindDn: pulumi.String("cn=ldapadmin,dc=contosoad,dc=contoso,dc=local"),
 * BindPassword: pulumi.String("<bindPassword>"),
 * },
 * ExtendedGroups: pulumi.Bool(true),
 * LdapBaseDN: pulumi.String("dc=contosoad,dc=contoso,dc=local"),
 * LdapServer: pulumi.String("192.0.2.12"),
 * UsernameSource: pulumi.String("LDAP"),
 * },
 * },
 * EncryptionSettings: storagecache.CacheEncryptionSettingsResponse{
 * KeyEncryptionKey: interface{}{
 * KeyUrl: pulumi.String("https://keyvault-cmk.vault.azure.net/keys/key2048/test"),
 * SourceVault: &storagecache.KeyVaultKeyReferenceSourceVaultArgs{
 * Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.KeyVault/vaults/keyvault-cmk"),
 * },
 * },
 * },
 * Location: pulumi.String("westus"),
 * ResourceGroupName: pulumi.String("scgroup"),
 * SecuritySettings: storagecache.CacheSecuritySettingsResponse{
 * AccessPolicies: storagecache.NfsAccessPolicyArray{
 * interface{}{
 * AccessRules: storagecache.NfsAccessRuleArray{
 * &storagecache.NfsAccessRuleArgs{
 * Access: pulumi.String("rw"),
 * RootSquash: pulumi.Bool(false),
 * Scope: pulumi.String("default"),
 * SubmountAccess: pulumi.Bool(true),
 * Suid: pulumi.Bool(false),
 * },
 * },
 * Name: pulumi.String("default"),
 * },
 * },
 * },
 * Sku: &storagecache.CacheSkuArgs{
 * Name: pulumi.String("Standard_2G"),
 * },
 * Subnet: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Network/virtualNetworks/scvnet/subnets/sub1"),
 * Tags: pulumi.StringMap{
 * "Dept": pulumi.String("Contoso"),
 * },
 * UpgradeSettings: &storagecache.CacheUpgradeSettingsArgs{
 * ScheduledTime: pulumi.String("2022-04-26T18:25:43.511Z"),
 * UpgradeScheduleEnabled: pulumi.Bool(true),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagecache.Cache;
 * import com.pulumi.azurenative.storagecache.CacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cache = new Cache("cache", CacheArgs.builder()
 *             .cacheName("sc1")
 *             .cacheSizeGB(3072)
 *             .directoryServicesSettings(Map.of("usernameDownload", Map.ofEntries(
 *                 Map.entry("credentials", Map.ofEntries(
 *                     Map.entry("bindDn", "cn=ldapadmin,dc=contosoad,dc=contoso,dc=local"),
 *                     Map.entry("bindPassword", "<bindPassword>")
 *                 )),
 *                 Map.entry("extendedGroups", true),
 *                 Map.entry("ldapBaseDN", "dc=contosoad,dc=contoso,dc=local"),
 *                 Map.entry("ldapServer", "192.0.2.12"),
 *                 Map.entry("usernameSource", "LDAP")
 *             )))
 *             .encryptionSettings(Map.of("keyEncryptionKey", Map.ofEntries(
 *                 Map.entry("keyUrl", "https://keyvault-cmk.vault.azure.net/keys/key2048/test"),
 *                 Map.entry("sourceVault", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.KeyVault/vaults/keyvault-cmk"))
 *             )))
 *             .location("westus")
 *             .resourceGroupName("scgroup")
 *             .securitySettings(Map.of("accessPolicies", Map.ofEntries(
 *                 Map.entry("accessRules", Map.ofEntries(
 *                     Map.entry("access", "rw"),
 *                     Map.entry("rootSquash", false),
 *                     Map.entry("scope", "default"),
 *                     Map.entry("submountAccess", true),
 *                     Map.entry("suid", false)
 *                 )),
 *                 Map.entry("name", "default")
 *             )))
 *             .sku(Map.of("name", "Standard_2G"))
 *             .subnet("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Network/virtualNetworks/scvnet/subnets/sub1")
 *             .tags(Map.of("Dept", "Contoso"))
 *             .upgradeSettings(Map.ofEntries(
 *                 Map.entry("scheduledTime", "2022-04-26T18:25:43.511Z"),
 *                 Map.entry("upgradeScheduleEnabled", true)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagecache:Cache sc1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}
 * ```
 * @property cacheName Name of cache. Length of name must not be greater than 80 and chars must be from the [-0-9a-zA-Z_] char class.
 * @property cacheSizeGB The size of this Cache, in GB.
 * @property directoryServicesSettings Specifies Directory Services settings of the cache.
 * @property encryptionSettings Specifies encryption settings of the cache.
 * @property identity The identity of the cache, if configured.
 * @property location Region name string.
 * @property networkSettings Specifies network settings of the cache.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securitySettings Specifies security settings of the cache.
 * @property sku SKU for the cache.
 * @property subnet Subnet used for the cache.
 * @property tags Resource tags.
 * @property upgradeSettings Upgrade settings of the cache.
 * @property zones Availability zones for resources. This field should only contain a single element in the array.
 */
public data class CacheArgs(
    public val cacheName: Output<String>? = null,
    public val cacheSizeGB: Output<Int>? = null,
    public val directoryServicesSettings: Output<CacheDirectorySettingsArgs>? = null,
    public val encryptionSettings: Output<CacheEncryptionSettingsArgs>? = null,
    public val identity: Output<CacheIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val networkSettings: Output<CacheNetworkSettingsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securitySettings: Output<CacheSecuritySettingsArgs>? = null,
    public val sku: Output<CacheSkuArgs>? = null,
    public val subnet: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val upgradeSettings: Output<CacheUpgradeSettingsArgs>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.CacheArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.CacheArgs =
        com.pulumi.azurenative.storagecache.CacheArgs.builder()
            .cacheName(cacheName?.applyValue({ args0 -> args0 }))
            .cacheSizeGB(cacheSizeGB?.applyValue({ args0 -> args0 }))
            .directoryServicesSettings(
                directoryServicesSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .encryptionSettings(
                encryptionSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkSettings(networkSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securitySettings(securitySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnet(subnet?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .upgradeSettings(upgradeSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CacheArgs].
 */
@PulumiTagMarker
public class CacheArgsBuilder internal constructor() {
    private var cacheName: Output<String>? = null

    private var cacheSizeGB: Output<Int>? = null

    private var directoryServicesSettings: Output<CacheDirectorySettingsArgs>? = null

    private var encryptionSettings: Output<CacheEncryptionSettingsArgs>? = null

    private var identity: Output<CacheIdentityArgs>? = null

    private var location: Output<String>? = null

    private var networkSettings: Output<CacheNetworkSettingsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var securitySettings: Output<CacheSecuritySettingsArgs>? = null

    private var sku: Output<CacheSkuArgs>? = null

    private var subnet: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var upgradeSettings: Output<CacheUpgradeSettingsArgs>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Name of cache. Length of name must not be greater than 80 and chars must be from the [-0-9a-zA-Z_] char class.
     */
    @JvmName("dkebfvbgblheraus")
    public suspend fun cacheName(`value`: Output<String>) {
        this.cacheName = value
    }

    /**
     * @param value The size of this Cache, in GB.
     */
    @JvmName("arvtvqjuocabldwg")
    public suspend fun cacheSizeGB(`value`: Output<Int>) {
        this.cacheSizeGB = value
    }

    /**
     * @param value Specifies Directory Services settings of the cache.
     */
    @JvmName("lfgddldochbvdbcq")
    public suspend fun directoryServicesSettings(`value`: Output<CacheDirectorySettingsArgs>) {
        this.directoryServicesSettings = value
    }

    /**
     * @param value Specifies encryption settings of the cache.
     */
    @JvmName("rgfossemwhymhvwh")
    public suspend fun encryptionSettings(`value`: Output<CacheEncryptionSettingsArgs>) {
        this.encryptionSettings = value
    }

    /**
     * @param value The identity of the cache, if configured.
     */
    @JvmName("pufgjnjivbymaukn")
    public suspend fun identity(`value`: Output<CacheIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Region name string.
     */
    @JvmName("ehyxvfvwwieskjfa")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies network settings of the cache.
     */
    @JvmName("hnmtrsxwsxqgypkm")
    public suspend fun networkSettings(`value`: Output<CacheNetworkSettingsArgs>) {
        this.networkSettings = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ulotpjunriqqguxy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies security settings of the cache.
     */
    @JvmName("lepynhxwninxgjgh")
    public suspend fun securitySettings(`value`: Output<CacheSecuritySettingsArgs>) {
        this.securitySettings = value
    }

    /**
     * @param value SKU for the cache.
     */
    @JvmName("kehnbykdsxcoyjtf")
    public suspend fun sku(`value`: Output<CacheSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Subnet used for the cache.
     */
    @JvmName("lrhsuvyhrojhmdgu")
    public suspend fun subnet(`value`: Output<String>) {
        this.subnet = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xdwouhtsmgaursov")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Upgrade settings of the cache.
     */
    @JvmName("bdaqxfruaucfeipg")
    public suspend fun upgradeSettings(`value`: Output<CacheUpgradeSettingsArgs>) {
        this.upgradeSettings = value
    }

    /**
     * @param value Availability zones for resources. This field should only contain a single element in the array.
     */
    @JvmName("tcbyrglawhwdhjbu")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("wylfuscknuuepqtd")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values Availability zones for resources. This field should only contain a single element in the array.
     */
    @JvmName("qarnkkjkfxubcyru")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Name of cache. Length of name must not be greater than 80 and chars must be from the [-0-9a-zA-Z_] char class.
     */
    @JvmName("eutajflkmgkgpdxp")
    public suspend fun cacheName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheName = mapped
    }

    /**
     * @param value The size of this Cache, in GB.
     */
    @JvmName("hmceksxhwdisnrbw")
    public suspend fun cacheSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheSizeGB = mapped
    }

    /**
     * @param value Specifies Directory Services settings of the cache.
     */
    @JvmName("livshcwuykpcbjih")
    public suspend fun directoryServicesSettings(`value`: CacheDirectorySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryServicesSettings = mapped
    }

    /**
     * @param argument Specifies Directory Services settings of the cache.
     */
    @JvmName("xnnvqllwhlsnmwlr")
    public suspend
    fun directoryServicesSettings(argument: suspend CacheDirectorySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CacheDirectorySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.directoryServicesSettings = mapped
    }

    /**
     * @param value Specifies encryption settings of the cache.
     */
    @JvmName("jxvsrfcbmsuyvvhd")
    public suspend fun encryptionSettings(`value`: CacheEncryptionSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionSettings = mapped
    }

    /**
     * @param argument Specifies encryption settings of the cache.
     */
    @JvmName("sjwabphjhiasximv")
    public suspend
    fun encryptionSettings(argument: suspend CacheEncryptionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CacheEncryptionSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionSettings = mapped
    }

    /**
     * @param value The identity of the cache, if configured.
     */
    @JvmName("apauipanxvaohtvs")
    public suspend fun identity(`value`: CacheIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the cache, if configured.
     */
    @JvmName("gxcmovmoclnlnyod")
    public suspend fun identity(argument: suspend CacheIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = CacheIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Region name string.
     */
    @JvmName("dmnyyccfhjpeepjk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies network settings of the cache.
     */
    @JvmName("mcgqjcdrahqhbvei")
    public suspend fun networkSettings(`value`: CacheNetworkSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSettings = mapped
    }

    /**
     * @param argument Specifies network settings of the cache.
     */
    @JvmName("jpraqtuwenrsogjp")
    public suspend fun networkSettings(argument: suspend CacheNetworkSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CacheNetworkSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkSettings = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ptetfxdfsxuswqjg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies security settings of the cache.
     */
    @JvmName("ciukvicktkssyylb")
    public suspend fun securitySettings(`value`: CacheSecuritySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securitySettings = mapped
    }

    /**
     * @param argument Specifies security settings of the cache.
     */
    @JvmName("esvhtuhlqqlcqfoo")
    public suspend
    fun securitySettings(argument: suspend CacheSecuritySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CacheSecuritySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securitySettings = mapped
    }

    /**
     * @param value SKU for the cache.
     */
    @JvmName("jpohbxqydwuhbiyi")
    public suspend fun sku(`value`: CacheSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU for the cache.
     */
    @JvmName("pxxtsloknmsgqgnk")
    public suspend fun sku(argument: suspend CacheSkuArgsBuilder.() -> Unit) {
        val toBeMapped = CacheSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Subnet used for the cache.
     */
    @JvmName("vsuvcattpnjbgknj")
    public suspend fun subnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fmbwhuvkqfkxtimq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("prfmejigrquykosm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Upgrade settings of the cache.
     */
    @JvmName("ijytflcykelmmatk")
    public suspend fun upgradeSettings(`value`: CacheUpgradeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeSettings = mapped
    }

    /**
     * @param argument Upgrade settings of the cache.
     */
    @JvmName("wyyjvhjfcgunqvwq")
    public suspend fun upgradeSettings(argument: suspend CacheUpgradeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CacheUpgradeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.upgradeSettings = mapped
    }

    /**
     * @param value Availability zones for resources. This field should only contain a single element in the array.
     */
    @JvmName("wnwqnjofjmojfypx")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values Availability zones for resources. This field should only contain a single element in the array.
     */
    @JvmName("fwbqbmknpvlrrced")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): CacheArgs = CacheArgs(
        cacheName = cacheName,
        cacheSizeGB = cacheSizeGB,
        directoryServicesSettings = directoryServicesSettings,
        encryptionSettings = encryptionSettings,
        identity = identity,
        location = location,
        networkSettings = networkSettings,
        resourceGroupName = resourceGroupName,
        securitySettings = securitySettings,
        sku = sku,
        subnet = subnet,
        tags = tags,
        upgradeSettings = upgradeSettings,
        zones = zones,
    )
}
