@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.AmlFilesystemHsmArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Hydration and archive settings and status
 * @property settings Specifies HSM settings of the AML file system.
 */
public data class AmlFilesystemHsmArgs(
    public val settings: Output<AmlFilesystemHsmSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.AmlFilesystemHsmArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.AmlFilesystemHsmArgs =
        com.pulumi.azurenative.storagecache.inputs.AmlFilesystemHsmArgs.builder()
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AmlFilesystemHsmArgs].
 */
@PulumiTagMarker
public class AmlFilesystemHsmArgsBuilder internal constructor() {
    private var settings: Output<AmlFilesystemHsmSettingsArgs>? = null

    /**
     * @param value Specifies HSM settings of the AML file system.
     */
    @JvmName("rdhjtmgbckgublsl")
    public suspend fun settings(`value`: Output<AmlFilesystemHsmSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value Specifies HSM settings of the AML file system.
     */
    @JvmName("aymutqfiumgbspjh")
    public suspend fun settings(`value`: AmlFilesystemHsmSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Specifies HSM settings of the AML file system.
     */
    @JvmName("tvhydxdjxlinebbu")
    public suspend fun settings(argument: suspend AmlFilesystemHsmSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AmlFilesystemHsmSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    internal fun build(): AmlFilesystemHsmArgs = AmlFilesystemHsmArgs(
        settings = settings,
    )
}
