@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.CacheUsernameDownloadSettingsCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * When present, these are the credentials for the secure LDAP connection.
 * @property bindDn The Bind Distinguished Name identity to be used in the secure LDAP connection. This value is stored encrypted and not returned on response.
 * @property bindPassword The Bind password to be used in the secure LDAP connection. This value is stored encrypted and not returned on response.
 */
public data class CacheUsernameDownloadSettingsCredentialsArgs(
    public val bindDn: Output<String>? = null,
    public val bindPassword: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.CacheUsernameDownloadSettingsCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.storagecache.inputs.CacheUsernameDownloadSettingsCredentialsArgs =
        com.pulumi.azurenative.storagecache.inputs.CacheUsernameDownloadSettingsCredentialsArgs.builder()
            .bindDn(bindDn?.applyValue({ args0 -> args0 }))
            .bindPassword(bindPassword?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CacheUsernameDownloadSettingsCredentialsArgs].
 */
@PulumiTagMarker
public class CacheUsernameDownloadSettingsCredentialsArgsBuilder internal constructor() {
    private var bindDn: Output<String>? = null

    private var bindPassword: Output<String>? = null

    /**
     * @param value The Bind Distinguished Name identity to be used in the secure LDAP connection. This value is stored encrypted and not returned on response.
     */
    @JvmName("ubnpqvvsbtxwtgfa")
    public suspend fun bindDn(`value`: Output<String>) {
        this.bindDn = value
    }

    /**
     * @param value The Bind password to be used in the secure LDAP connection. This value is stored encrypted and not returned on response.
     */
    @JvmName("yyscilixjkltwpxm")
    public suspend fun bindPassword(`value`: Output<String>) {
        this.bindPassword = value
    }

    /**
     * @param value The Bind Distinguished Name identity to be used in the secure LDAP connection. This value is stored encrypted and not returned on response.
     */
    @JvmName("vitpkgymdtlfosgj")
    public suspend fun bindDn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindDn = mapped
    }

    /**
     * @param value The Bind password to be used in the secure LDAP connection. This value is stored encrypted and not returned on response.
     */
    @JvmName("vggnujikwyllsipm")
    public suspend fun bindPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindPassword = mapped
    }

    internal fun build(): CacheUsernameDownloadSettingsCredentialsArgs =
        CacheUsernameDownloadSettingsCredentialsArgs(
            bindDn = bindDn,
            bindPassword = bindPassword,
        )
}
