@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.ClfsTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties pertaining to the ClfsTarget
 * @property target Resource ID of storage container.
 */
public data class ClfsTargetArgs(
    public val target: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.ClfsTargetArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.ClfsTargetArgs =
        com.pulumi.azurenative.storagecache.inputs.ClfsTargetArgs.builder()
            .target(target?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClfsTargetArgs].
 */
@PulumiTagMarker
public class ClfsTargetArgsBuilder internal constructor() {
    private var target: Output<String>? = null

    /**
     * @param value Resource ID of storage container.
     */
    @JvmName("guobysmvfdoppqry")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Resource ID of storage container.
     */
    @JvmName("yymiuhtvpccsvasx")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): ClfsTargetArgs = ClfsTargetArgs(
        target = target,
    )
}
