@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.NfsAccessRuleArgs.builder
import com.pulumi.azurenative.storagecache.kotlin.enums.NfsAccessRuleAccess
import com.pulumi.azurenative.storagecache.kotlin.enums.NfsAccessRuleScope
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Rule to place restrictions on portions of the cache namespace being presented to clients.
 * @property access Access allowed by this rule.
 * @property anonymousGID GID value that replaces 0 when rootSquash is true. This will use the value of anonymousUID if not provided.
 * @property anonymousUID UID value that replaces 0 when rootSquash is true. 65534 will be used if not provided.
 * @property filter Filter applied to the scope for this rule. The filter's format depends on its scope. 'default' scope matches all clients and has no filter value. 'network' scope takes a filter in CIDR format (for example, 10.99.1.0/24). 'host' takes an IP address or fully qualified domain name as filter. If a client does not match any filter rule and there is no default rule, access is denied.
 * @property rootSquash Map root accesses to anonymousUID and anonymousGID.
 * @property scope Scope for this rule. The scope and filter determine which clients match the rule.
 * @property submountAccess For the default policy, allow access to subdirectories under the root export. If this is set to no, clients can only mount the path '/'. If set to yes, clients can mount a deeper path, like '/a/b'.
 * @property suid Allow SUID semantics.
 */
public data class NfsAccessRuleArgs(
    public val access: Output<Either<String, NfsAccessRuleAccess>>,
    public val anonymousGID: Output<String>? = null,
    public val anonymousUID: Output<String>? = null,
    public val filter: Output<String>? = null,
    public val rootSquash: Output<Boolean>? = null,
    public val scope: Output<Either<String, NfsAccessRuleScope>>,
    public val submountAccess: Output<Boolean>? = null,
    public val suid: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.NfsAccessRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.NfsAccessRuleArgs =
        com.pulumi.azurenative.storagecache.inputs.NfsAccessRuleArgs.builder()
            .access(
                access.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .anonymousGID(anonymousGID?.applyValue({ args0 -> args0 }))
            .anonymousUID(anonymousUID?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0 }))
            .rootSquash(rootSquash?.applyValue({ args0 -> args0 }))
            .scope(
                scope.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .submountAccess(submountAccess?.applyValue({ args0 -> args0 }))
            .suid(suid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NfsAccessRuleArgs].
 */
@PulumiTagMarker
public class NfsAccessRuleArgsBuilder internal constructor() {
    private var access: Output<Either<String, NfsAccessRuleAccess>>? = null

    private var anonymousGID: Output<String>? = null

    private var anonymousUID: Output<String>? = null

    private var filter: Output<String>? = null

    private var rootSquash: Output<Boolean>? = null

    private var scope: Output<Either<String, NfsAccessRuleScope>>? = null

    private var submountAccess: Output<Boolean>? = null

    private var suid: Output<Boolean>? = null

    /**
     * @param value Access allowed by this rule.
     */
    @JvmName("yfonqxlotyvfgywd")
    public suspend fun access(`value`: Output<Either<String, NfsAccessRuleAccess>>) {
        this.access = value
    }

    /**
     * @param value GID value that replaces 0 when rootSquash is true. This will use the value of anonymousUID if not provided.
     */
    @JvmName("rsotvryhpybgusmw")
    public suspend fun anonymousGID(`value`: Output<String>) {
        this.anonymousGID = value
    }

    /**
     * @param value UID value that replaces 0 when rootSquash is true. 65534 will be used if not provided.
     */
    @JvmName("dxltobkxtkfbpxdb")
    public suspend fun anonymousUID(`value`: Output<String>) {
        this.anonymousUID = value
    }

    /**
     * @param value Filter applied to the scope for this rule. The filter's format depends on its scope. 'default' scope matches all clients and has no filter value. 'network' scope takes a filter in CIDR format (for example, 10.99.1.0/24). 'host' takes an IP address or fully qualified domain name as filter. If a client does not match any filter rule and there is no default rule, access is denied.
     */
    @JvmName("mfsycyoeafgnjdyi")
    public suspend fun filter(`value`: Output<String>) {
        this.filter = value
    }

    /**
     * @param value Map root accesses to anonymousUID and anonymousGID.
     */
    @JvmName("mxiiethysodqjyou")
    public suspend fun rootSquash(`value`: Output<Boolean>) {
        this.rootSquash = value
    }

    /**
     * @param value Scope for this rule. The scope and filter determine which clients match the rule.
     */
    @JvmName("gnpbsxqtdguplras")
    public suspend fun scope(`value`: Output<Either<String, NfsAccessRuleScope>>) {
        this.scope = value
    }

    /**
     * @param value For the default policy, allow access to subdirectories under the root export. If this is set to no, clients can only mount the path '/'. If set to yes, clients can mount a deeper path, like '/a/b'.
     */
    @JvmName("njrbouqddywlqbwr")
    public suspend fun submountAccess(`value`: Output<Boolean>) {
        this.submountAccess = value
    }

    /**
     * @param value Allow SUID semantics.
     */
    @JvmName("xvqavnnkkowvfwpc")
    public suspend fun suid(`value`: Output<Boolean>) {
        this.suid = value
    }

    /**
     * @param value Access allowed by this rule.
     */
    @JvmName("wddgwwpyrpcyffsb")
    public suspend fun access(`value`: Either<String, NfsAccessRuleAccess>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value Access allowed by this rule.
     */
    @JvmName("cjxmkqbbemdqmbfu")
    public fun access(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NfsAccessRuleAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value Access allowed by this rule.
     */
    @JvmName("pxlihgnvvjsiasco")
    public fun access(`value`: NfsAccessRuleAccess) {
        val toBeMapped = Either.ofRight<String, NfsAccessRuleAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value GID value that replaces 0 when rootSquash is true. This will use the value of anonymousUID if not provided.
     */
    @JvmName("rakvcyvyjuoqucjf")
    public suspend fun anonymousGID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.anonymousGID = mapped
    }

    /**
     * @param value UID value that replaces 0 when rootSquash is true. 65534 will be used if not provided.
     */
    @JvmName("cqriianskdclmdsd")
    public suspend fun anonymousUID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.anonymousUID = mapped
    }

    /**
     * @param value Filter applied to the scope for this rule. The filter's format depends on its scope. 'default' scope matches all clients and has no filter value. 'network' scope takes a filter in CIDR format (for example, 10.99.1.0/24). 'host' takes an IP address or fully qualified domain name as filter. If a client does not match any filter rule and there is no default rule, access is denied.
     */
    @JvmName("mycsmpbxtnyjlfgk")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value Map root accesses to anonymousUID and anonymousGID.
     */
    @JvmName("fqncqxfdqbukbaab")
    public suspend fun rootSquash(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootSquash = mapped
    }

    /**
     * @param value Scope for this rule. The scope and filter determine which clients match the rule.
     */
    @JvmName("jfctwcgmrjcgwlcg")
    public suspend fun scope(`value`: Either<String, NfsAccessRuleScope>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Scope for this rule. The scope and filter determine which clients match the rule.
     */
    @JvmName("ycctfvrmmfvpsfbv")
    public fun scope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NfsAccessRuleScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Scope for this rule. The scope and filter determine which clients match the rule.
     */
    @JvmName("qxsyxnomtcckukwr")
    public fun scope(`value`: NfsAccessRuleScope) {
        val toBeMapped = Either.ofRight<String, NfsAccessRuleScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value For the default policy, allow access to subdirectories under the root export. If this is set to no, clients can only mount the path '/'. If set to yes, clients can mount a deeper path, like '/a/b'.
     */
    @JvmName("denfueyguktrmqca")
    public suspend fun submountAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.submountAccess = mapped
    }

    /**
     * @param value Allow SUID semantics.
     */
    @JvmName("thoxkobqhwdodoeu")
    public suspend fun suid(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suid = mapped
    }

    internal fun build(): NfsAccessRuleArgs = NfsAccessRuleArgs(
        access = access ?: throw PulumiNullFieldException("access"),
        anonymousGID = anonymousGID,
        anonymousUID = anonymousUID,
        filter = filter,
        rootSquash = rootSquash,
        scope = scope ?: throw PulumiNullFieldException("scope"),
        submountAccess = submountAccess,
        suid = suid,
    )
}
