@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The status of the archive
 * @property errorCode Server-defined error code for the archive operation
 * @property errorMessage Server-defined error message for the archive operation
 * @property lastCompletionTime The time of the last completed archive operation
 * @property lastStartedTime The time the latest archive operation started
 * @property percentComplete The completion percentage of the archive operation
 * @property state The state of the archive operation
 */
public data class AmlFilesystemArchiveResponseStatus(
    public val errorCode: String,
    public val errorMessage: String,
    public val lastCompletionTime: String,
    public val lastStartedTime: String,
    public val percentComplete: Int,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.AmlFilesystemArchiveResponseStatus):
            AmlFilesystemArchiveResponseStatus = AmlFilesystemArchiveResponseStatus(
            errorCode = javaType.errorCode(),
            errorMessage = javaType.errorMessage(),
            lastCompletionTime = javaType.lastCompletionTime(),
            lastStartedTime = javaType.lastStartedTime(),
            percentComplete = javaType.percentComplete(),
            state = javaType.state(),
        )
    }
}
