@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * AML file system container storage interface information
 * @property persistentVolume Recommended AKS Persistent Volume for the CSI driver, in Base64 encoded YAML
 * @property persistentVolumeClaim Recommended AKS Persistent Volume Claim for the CSI driver, in Base64 encoded YAML
 * @property storageClass Recommended AKS Storage Class for the CSI driver, in Base64 encoded YAML
 */
public data class AmlFilesystemContainerStorageInterfaceResponse(
    public val persistentVolume: String,
    public val persistentVolumeClaim: String,
    public val storageClass: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.AmlFilesystemContainerStorageInterfaceResponse):
            AmlFilesystemContainerStorageInterfaceResponse =
            AmlFilesystemContainerStorageInterfaceResponse(
                persistentVolume = javaType.persistentVolume(),
                persistentVolumeClaim = javaType.persistentVolumeClaim(),
                storageClass = javaType.storageClass(),
            )
    }
}
