@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Cache security settings.
 * @property accessPolicies NFS access policies defined for this cache.
 */
public data class CacheSecuritySettingsResponse(
    public val accessPolicies: List<NfsAccessPolicyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.CacheSecuritySettingsResponse):
            CacheSecuritySettingsResponse = CacheSecuritySettingsResponse(
            accessPolicies = javaType.accessPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.NfsAccessPolicyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
