@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Cache Upgrade Settings.
 * @property scheduledTime When upgradeScheduleEnabled is true, this field holds the user-chosen upgrade time. At the user-chosen time, the firmware update will automatically be installed on the cache.
 * @property upgradeScheduleEnabled True if the user chooses to select an installation time between now and firmwareUpdateDeadline. Else the firmware will automatically be installed after firmwareUpdateDeadline if not triggered earlier via the upgrade operation.
 */
public data class CacheUpgradeSettingsResponse(
    public val scheduledTime: String? = null,
    public val upgradeScheduleEnabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.CacheUpgradeSettingsResponse):
            CacheUpgradeSettingsResponse = CacheUpgradeSettingsResponse(
            scheduledTime = javaType.scheduledTime().map({ args0 -> args0 }).orElse(null),
            upgradeScheduleEnabled = javaType.upgradeScheduleEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
