@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Settings for Extended Groups username and group download.
 * @property autoDownloadCertificate Determines if the certificate should be automatically downloaded. This applies to 'caCertificateURI' only if 'requireValidCertificate' is true.
 * @property caCertificateURI The URI of the CA certificate to validate the LDAP secure connection. This field must be populated when 'requireValidCertificate' is set to true.
 * @property credentials When present, these are the credentials for the secure LDAP connection.
 * @property encryptLdapConnection Whether or not the LDAP connection should be encrypted.
 * @property extendedGroups Whether or not Extended Groups is enabled.
 * @property groupFileURI The URI of the file containing group information (in /etc/group file format). This field must be populated when 'usernameSource' is set to 'File'.
 * @property ldapBaseDN The base distinguished name for the LDAP domain.
 * @property ldapServer The fully qualified domain name or IP address of the LDAP server to use.
 * @property requireValidCertificate Determines if the certificates must be validated by a certificate authority. When true, caCertificateURI must be provided.
 * @property userFileURI The URI of the file containing user information (in /etc/passwd file format). This field must be populated when 'usernameSource' is set to 'File'.
 * @property usernameDownloaded Indicates whether or not the HPC Cache has performed the username download successfully.
 * @property usernameSource This setting determines how the cache gets username and group names for clients.
 */
public data class CacheUsernameDownloadSettingsResponse(
    public val autoDownloadCertificate: Boolean? = null,
    public val caCertificateURI: String? = null,
    public val credentials: CacheUsernameDownloadSettingsResponseCredentials? = null,
    public val encryptLdapConnection: Boolean? = null,
    public val extendedGroups: Boolean? = null,
    public val groupFileURI: String? = null,
    public val ldapBaseDN: String? = null,
    public val ldapServer: String? = null,
    public val requireValidCertificate: Boolean? = null,
    public val userFileURI: String? = null,
    public val usernameDownloaded: String,
    public val usernameSource: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.CacheUsernameDownloadSettingsResponse):
            CacheUsernameDownloadSettingsResponse = CacheUsernameDownloadSettingsResponse(
            autoDownloadCertificate = javaType.autoDownloadCertificate().map({ args0 -> args0 }).orElse(null),
            caCertificateURI = javaType.caCertificateURI().map({ args0 -> args0 }).orElse(null),
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.CacheUsernameDownloadSettingsResponseCredentials.Companion.toKotlin(args0)
                })
            }).orElse(null),
            encryptLdapConnection = javaType.encryptLdapConnection().map({ args0 -> args0 }).orElse(null),
            extendedGroups = javaType.extendedGroups().map({ args0 -> args0 }).orElse(null),
            groupFileURI = javaType.groupFileURI().map({ args0 -> args0 }).orElse(null),
            ldapBaseDN = javaType.ldapBaseDN().map({ args0 -> args0 }).orElse(null),
            ldapServer = javaType.ldapServer().map({ args0 -> args0 }).orElse(null),
            requireValidCertificate = javaType.requireValidCertificate().map({ args0 -> args0 }).orElse(null),
            userFileURI = javaType.userFileURI().map({ args0 -> args0 }).orElse(null),
            usernameDownloaded = javaType.usernameDownloaded(),
            usernameSource = javaType.usernameSource().map({ args0 -> args0 }).orElse(null),
        )
    }
}
