@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin.inputs

import com.pulumi.azurenative.storagemover.inputs.GetJobDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobDefinitionName The name of the Job Definition resource.
 * @property projectName The name of the Project resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageMoverName The name of the Storage Mover resource.
 */
public data class GetJobDefinitionPlainArgs(
    public val jobDefinitionName: String,
    public val projectName: String,
    public val resourceGroupName: String,
    public val storageMoverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagemover.inputs.GetJobDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagemover.inputs.GetJobDefinitionPlainArgs =
        com.pulumi.azurenative.storagemover.inputs.GetJobDefinitionPlainArgs.builder()
            .jobDefinitionName(jobDefinitionName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageMoverName(storageMoverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetJobDefinitionPlainArgsBuilder internal constructor() {
    private var jobDefinitionName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    private var storageMoverName: String? = null

    /**
     * @param value The name of the Job Definition resource.
     */
    @JvmName("pngqaleunkcipaeu")
    public suspend fun jobDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobDefinitionName = mapped
    }

    /**
     * @param value The name of the Project resource.
     */
    @JvmName("edyynkpvkpwjgvpj")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ivxwoleflfgmjxug")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("mjsubjfwtgjndfhd")
    public suspend fun storageMoverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageMoverName = mapped
    }

    internal fun build(): GetJobDefinitionPlainArgs = GetJobDefinitionPlainArgs(
        jobDefinitionName = jobDefinitionName ?: throw PulumiNullFieldException("jobDefinitionName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageMoverName = storageMoverName ?: throw PulumiNullFieldException("storageMoverName"),
    )
}
