@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin.inputs

import com.pulumi.azurenative.storagemover.inputs.GetStorageMoverPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageMoverName The name of the Storage Mover resource.
 */
public data class GetStorageMoverPlainArgs(
    public val resourceGroupName: String,
    public val storageMoverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagemover.inputs.GetStorageMoverPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagemover.inputs.GetStorageMoverPlainArgs =
        com.pulumi.azurenative.storagemover.inputs.GetStorageMoverPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageMoverName(storageMoverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageMoverPlainArgs].
 */
@PulumiTagMarker
public class GetStorageMoverPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var storageMoverName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("csfhaktilgywqhvv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("cguqhwburvhsfcod")
    public suspend fun storageMoverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageMoverName = mapped
    }

    internal fun build(): GetStorageMoverPlainArgs = GetStorageMoverPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageMoverName = storageMoverName ?: throw PulumiNullFieldException("storageMoverName"),
    )
}
