@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property blobContainerName The name of the Storage blob container that is the target destination.
 * @property description A description for the Endpoint.
 * @property endpointType The Endpoint resource type.
 * Expected value is 'AzureStorageBlobContainer'.
 * @property provisioningState The provisioning state of this resource.
 * @property storageAccountResourceId The Azure Resource ID of the storage account that is the target destination.
 */
public data class AzureStorageBlobContainerEndpointPropertiesResponse(
    public val blobContainerName: String,
    public val description: String? = null,
    public val endpointType: String,
    public val provisioningState: String,
    public val storageAccountResourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagemover.outputs.AzureStorageBlobContainerEndpointPropertiesResponse):
            AzureStorageBlobContainerEndpointPropertiesResponse =
            AzureStorageBlobContainerEndpointPropertiesResponse(
                blobContainerName = javaType.blobContainerName(),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                endpointType = javaType.endpointType(),
                provisioningState = javaType.provisioningState(),
                storageAccountResourceId = javaType.storageAccountResourceId(),
            )
    }
}
