@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin

import com.pulumi.azurenative.storagesync.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.storagesync.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [StorageSyncService].
 */
@PulumiTagMarker
public class StorageSyncServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageSyncServiceArgs = StorageSyncServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageSyncServiceArgsBuilder.() -> Unit) {
        val builder = StorageSyncServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StorageSyncService {
        val builtJavaResource =
            com.pulumi.azurenative.storagesync.StorageSyncService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageSyncService(builtJavaResource)
    }
}

/**
 * Storage Sync Service object.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2017-06-05-preview, 2019-10-01, 2022-09-01.
 * ## Example Usage
 * ### StorageSyncServices_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageSyncService = new AzureNative.StorageSync.StorageSyncService("storageSyncService", new()
 *     {
 *         IncomingTrafficPolicy = "AllowAllTraffic",
 *         Location = "WestUS",
 *         ResourceGroupName = "SampleResourceGroup_1",
 *         StorageSyncServiceName = "SampleStorageSyncService_1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagesync/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagesync.NewStorageSyncService(ctx, "storageSyncService", &storagesync.StorageSyncServiceArgs{
 * 			IncomingTrafficPolicy:  pulumi.String("AllowAllTraffic"),
 * 			Location:               pulumi.String("WestUS"),
 * 			ResourceGroupName:      pulumi.String("SampleResourceGroup_1"),
 * 			StorageSyncServiceName: pulumi.String("SampleStorageSyncService_1"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagesync.StorageSyncService;
 * import com.pulumi.azurenative.storagesync.StorageSyncServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageSyncService = new StorageSyncService("storageSyncService", StorageSyncServiceArgs.builder()
 *             .incomingTrafficPolicy("AllowAllTraffic")
 *             .location("WestUS")
 *             .resourceGroupName("SampleResourceGroup_1")
 *             .storageSyncServiceName("SampleStorageSyncService_1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagesync:StorageSyncService SampleStorageSyncService_1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageSync/storageSyncServices/{storageSyncServiceName}
 * ```
 */
public class StorageSyncService internal constructor(
    override val javaResource: com.pulumi.azurenative.storagesync.StorageSyncService,
) : KotlinCustomResource(javaResource, StorageSyncServiceMapper) {
    /**
     * Incoming Traffic Policy
     */
    public val incomingTrafficPolicy: Output<String>?
        get() = javaResource.incomingTrafficPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Last Operation Name
     */
    public val lastOperationName: Output<String>
        get() = javaResource.lastOperationName().applyValue({ args0 -> args0 })

    /**
     * StorageSyncService lastWorkflowId
     */
    public val lastWorkflowId: Output<String>
        get() = javaResource.lastWorkflowId().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connection associated with the specified storage sync service
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * StorageSyncService Provisioning State
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Storage Sync service status.
     */
    public val storageSyncServiceStatus: Output<Int>
        get() = javaResource.storageSyncServiceStatus().applyValue({ args0 -> args0 })

    /**
     * Storage Sync service Uid
     */
    public val storageSyncServiceUid: Output<String>
        get() = javaResource.storageSyncServiceUid().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StorageSyncServiceMapper : ResourceMapper<StorageSyncService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagesync.StorageSyncService::class == javaResource::class

    override fun map(javaResource: Resource): StorageSyncService = StorageSyncService(
        javaResource as
            com.pulumi.azurenative.storagesync.StorageSyncService,
    )
}

/**
 * @see [StorageSyncService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageSyncService].
 */
public suspend fun storageSyncService(
    name: String,
    block: suspend StorageSyncServiceResourceBuilder.() -> Unit,
): StorageSyncService {
    val builder = StorageSyncServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageSyncService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageSyncService(name: String): StorageSyncService {
    val builder = StorageSyncServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
