@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.inputs

import com.pulumi.azurenative.storagesync.inputs.GetCloudEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudEndpointName Name of Cloud Endpoint object.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageSyncServiceName Name of Storage Sync Service resource.
 * @property syncGroupName Name of Sync Group resource.
 */
public data class GetCloudEndpointPlainArgs(
    public val cloudEndpointName: String,
    public val resourceGroupName: String,
    public val storageSyncServiceName: String,
    public val syncGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagesync.inputs.GetCloudEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagesync.inputs.GetCloudEndpointPlainArgs =
        com.pulumi.azurenative.storagesync.inputs.GetCloudEndpointPlainArgs.builder()
            .cloudEndpointName(cloudEndpointName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageSyncServiceName(storageSyncServiceName.let({ args0 -> args0 }))
            .syncGroupName(syncGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCloudEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetCloudEndpointPlainArgsBuilder internal constructor() {
    private var cloudEndpointName: String? = null

    private var resourceGroupName: String? = null

    private var storageSyncServiceName: String? = null

    private var syncGroupName: String? = null

    /**
     * @param value Name of Cloud Endpoint object.
     */
    @JvmName("uggjhnrixgblhgcc")
    public suspend fun cloudEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cloudEndpointName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ivkvjllwslmiejha")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("moatoclgoawtried")
    public suspend fun storageSyncServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageSyncServiceName = mapped
    }

    /**
     * @param value Name of Sync Group resource.
     */
    @JvmName("xypwnqhecqblxgou")
    public suspend fun syncGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.syncGroupName = mapped
    }

    internal fun build(): GetCloudEndpointPlainArgs = GetCloudEndpointPlainArgs(
        cloudEndpointName = cloudEndpointName ?: throw PulumiNullFieldException("cloudEndpointName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageSyncServiceName = storageSyncServiceName ?: throw
            PulumiNullFieldException("storageSyncServiceName"),
        syncGroupName = syncGroupName ?: throw PulumiNullFieldException("syncGroupName"),
    )
}
