@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.inputs

import com.pulumi.azurenative.storagesync.inputs.GetServerEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverEndpointName Name of Server Endpoint object.
 * @property storageSyncServiceName Name of Storage Sync Service resource.
 * @property syncGroupName Name of Sync Group resource.
 */
public data class GetServerEndpointPlainArgs(
    public val resourceGroupName: String,
    public val serverEndpointName: String,
    public val storageSyncServiceName: String,
    public val syncGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagesync.inputs.GetServerEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagesync.inputs.GetServerEndpointPlainArgs =
        com.pulumi.azurenative.storagesync.inputs.GetServerEndpointPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverEndpointName(serverEndpointName.let({ args0 -> args0 }))
            .storageSyncServiceName(storageSyncServiceName.let({ args0 -> args0 }))
            .syncGroupName(syncGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetServerEndpointPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serverEndpointName: String? = null

    private var storageSyncServiceName: String? = null

    private var syncGroupName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dnmyavnwjgqgtymf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Server Endpoint object.
     */
    @JvmName("khnxdtvnpnltjare")
    public suspend fun serverEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverEndpointName = mapped
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("ldbqanpellpqeuej")
    public suspend fun storageSyncServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageSyncServiceName = mapped
    }

    /**
     * @param value Name of Sync Group resource.
     */
    @JvmName("nbqpnwehfebvfclx")
    public suspend fun syncGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.syncGroupName = mapped
    }

    internal fun build(): GetServerEndpointPlainArgs = GetServerEndpointPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverEndpointName = serverEndpointName ?: throw PulumiNullFieldException("serverEndpointName"),
        storageSyncServiceName = storageSyncServiceName ?: throw
            PulumiNullFieldException("storageSyncServiceName"),
        syncGroupName = syncGroupName ?: throw PulumiNullFieldException("syncGroupName"),
    )
}
