@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Status of the volume free space policy
 * @property currentVolumeFreeSpacePercent Current volume free space percentage.
 * @property effectiveVolumeFreeSpacePolicy In the case where multiple server endpoints are present in a volume, an effective free space policy is applied.
 * @property lastUpdatedTimestamp Last updated timestamp
 */
public data class CloudTieringVolumeFreeSpacePolicyStatusResponse(
    public val currentVolumeFreeSpacePercent: Int,
    public val effectiveVolumeFreeSpacePolicy: Int,
    public val lastUpdatedTimestamp: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.CloudTieringVolumeFreeSpacePolicyStatusResponse):
            CloudTieringVolumeFreeSpacePolicyStatusResponse =
            CloudTieringVolumeFreeSpacePolicyStatusResponse(
                currentVolumeFreeSpacePercent = javaType.currentVolumeFreeSpacePercent(),
                effectiveVolumeFreeSpacePolicy = javaType.effectiveVolumeFreeSpacePolicy(),
                lastUpdatedTimestamp = javaType.lastUpdatedTimestamp(),
            )
    }
}
