@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.kotlin.outputs.BandwidthScheduleResponse
import com.pulumi.azurenative.storsimple.kotlin.outputs.BandwidthScheduleResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BandwidthSetting].
 */
@PulumiTagMarker
public class BandwidthSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BandwidthSettingArgs = BandwidthSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BandwidthSettingArgsBuilder.() -> Unit) {
        val builder = BandwidthSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BandwidthSetting {
        val builtJavaResource =
            com.pulumi.azurenative.storsimple.BandwidthSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BandwidthSetting(builtJavaResource)
    }
}

/**
 * The bandwidth setting.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### BandwidthSettingsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bandwidthSetting = new AzureNative.StorSimple.BandwidthSetting("bandwidthSetting", new()
 *     {
 *         BandwidthSettingName = "BWSForTest",
 *         ManagerName = "ManagerForSDKTest1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         Schedules = new[]
 *         {
 *             new AzureNative.StorSimple.Inputs.BandwidthScheduleArgs
 *             {
 *                 Days = new[]
 *                 {
 *                     AzureNative.StorSimple.DayOfWeek.Saturday,
 *                     AzureNative.StorSimple.DayOfWeek.Sunday,
 *                 },
 *                 RateInMbps = 10,
 *                 Start = new AzureNative.StorSimple.Inputs.TimeArgs
 *                 {
 *                     Hours = 10,
 *                     Minutes = 0,
 *                     Seconds = 0,
 *                 },
 *                 Stop = new AzureNative.StorSimple.Inputs.TimeArgs
 *                 {
 *                     Hours = 20,
 *                     Minutes = 0,
 *                     Seconds = 0,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewBandwidthSetting(ctx, "bandwidthSetting", &storsimple.BandwidthSettingArgs{
 * 			BandwidthSettingName: pulumi.String("BWSForTest"),
 * 			ManagerName:          pulumi.String("ManagerForSDKTest1"),
 * 			ResourceGroupName:    pulumi.String("ResourceGroupForSDKTest"),
 * 			Schedules: []storsimple.BandwidthScheduleArgs{
 * 				{
 * 					Days: storsimple.DayOfWeekArray{
 * 						storsimple.DayOfWeekSaturday,
 * 						storsimple.DayOfWeekSunday,
 * 					},
 * 					RateInMbps: pulumi.Int(10),
 * 					Start: {
 * 						Hours:   pulumi.Int(10),
 * 						Minutes: pulumi.Int(0),
 * 						Seconds: pulumi.Int(0),
 * 					},
 * 					Stop: {
 * 						Hours:   pulumi.Int(20),
 * 						Minutes: pulumi.Int(0),
 * 						Seconds: pulumi.Int(0),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.BandwidthSetting;
 * import com.pulumi.azurenative.storsimple.BandwidthSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bandwidthSetting = new BandwidthSetting("bandwidthSetting", BandwidthSettingArgs.builder()
 *             .bandwidthSettingName("BWSForTest")
 *             .managerName("ManagerForSDKTest1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .schedules(Map.ofEntries(
 *                 Map.entry("days",
 *                     "Saturday",
 *                     "Sunday"),
 *                 Map.entry("rateInMbps", 10),
 *                 Map.entry("start", Map.ofEntries(
 *                     Map.entry("hours", 10),
 *                     Map.entry("minutes", 0),
 *                     Map.entry("seconds", 0)
 *                 )),
 *                 Map.entry("stop", Map.ofEntries(
 *                     Map.entry("hours", 20),
 *                     Map.entry("minutes", 0),
 *                     Map.entry("seconds", 0)
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:BandwidthSetting BWSForTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/bandwidthSettings/{bandwidthSettingName}
 * ```
 */
public class BandwidthSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.storsimple.BandwidthSetting,
) : KotlinCustomResource(javaResource, BandwidthSettingMapper) {
    /**
     * The Kind of the object. Currently only Series8000 is supported
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the object.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The schedules.
     */
    public val schedules: Output<List<BandwidthScheduleResponse>>
        get() = javaResource.schedules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The number of volumes that uses the bandwidth setting.
     */
    public val volumeCount: Output<Int>
        get() = javaResource.volumeCount().applyValue({ args0 -> args0 })
}

public object BandwidthSettingMapper : ResourceMapper<BandwidthSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storsimple.BandwidthSetting::class == javaResource::class

    override fun map(javaResource: Resource): BandwidthSetting = BandwidthSetting(
        javaResource as
            com.pulumi.azurenative.storsimple.BandwidthSetting,
    )
}

/**
 * @see [BandwidthSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BandwidthSetting].
 */
public suspend fun bandwidthSetting(
    name: String,
    block: suspend BandwidthSettingResourceBuilder.() -> Unit,
): BandwidthSetting {
    val builder = BandwidthSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BandwidthSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bandwidthSetting(name: String): BandwidthSetting {
    val builder = BandwidthSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
