@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.ManagerExtendedInfoArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.Kind
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The extended info of the manager.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### ManagersCreateExtendedInfo
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managerExtendedInfo = new AzureNative.StorSimple.ManagerExtendedInfo("managerExtendedInfo", new()
 *     {
 *         Algorithm = "None",
 *         IntegrityKey = "BIl+RHqO8PZ6DRvuXTTK7g==",
 *         ManagerName = "ManagerForSDKTest2",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewManagerExtendedInfo(ctx, "managerExtendedInfo", &storsimple.ManagerExtendedInfoArgs{
 * 			Algorithm:         pulumi.String("None"),
 * 			IntegrityKey:      pulumi.String("BIl+RHqO8PZ6DRvuXTTK7g=="),
 * 			ManagerName:       pulumi.String("ManagerForSDKTest2"),
 * 			ResourceGroupName: pulumi.String("ResourceGroupForSDKTest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.ManagerExtendedInfo;
 * import com.pulumi.azurenative.storsimple.ManagerExtendedInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managerExtendedInfo = new ManagerExtendedInfo("managerExtendedInfo", ManagerExtendedInfoArgs.builder()
 *             .algorithm("None")
 *             .integrityKey("BIl+RHqO8PZ6DRvuXTTK7g==")
 *             .managerName("ManagerForSDKTest2")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:ManagerExtendedInfo vaultExtendedInfo /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo
 * ```
 * @property algorithm Represents the encryption algorithm used to encrypt the keys. None - if Key is saved in plain text format. Algorithm name - if key is encrypted
 * @property encryptionKey Represents the CEK of the resource.
 * @property encryptionKeyThumbprint Represents the Cert thumbprint that was used to encrypt the CEK.
 * @property integrityKey Represents the CIK of the resource.
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property managerName The manager name
 * @property portalCertificateThumbprint Represents the portal thumbprint which can be used optionally to encrypt the entire data before storing it.
 * @property resourceGroupName The resource group name
 * @property version The version of the extended info being persisted.
 */
public data class ManagerExtendedInfoArgs(
    public val algorithm: Output<String>? = null,
    public val encryptionKey: Output<String>? = null,
    public val encryptionKeyThumbprint: Output<String>? = null,
    public val integrityKey: Output<String>? = null,
    public val kind: Output<Kind>? = null,
    public val managerName: Output<String>? = null,
    public val portalCertificateThumbprint: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.ManagerExtendedInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.ManagerExtendedInfoArgs =
        com.pulumi.azurenative.storsimple.ManagerExtendedInfoArgs.builder()
            .algorithm(algorithm?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0 }))
            .encryptionKeyThumbprint(encryptionKeyThumbprint?.applyValue({ args0 -> args0 }))
            .integrityKey(integrityKey?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managerName(managerName?.applyValue({ args0 -> args0 }))
            .portalCertificateThumbprint(portalCertificateThumbprint?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagerExtendedInfoArgs].
 */
@PulumiTagMarker
public class ManagerExtendedInfoArgsBuilder internal constructor() {
    private var algorithm: Output<String>? = null

    private var encryptionKey: Output<String>? = null

    private var encryptionKeyThumbprint: Output<String>? = null

    private var integrityKey: Output<String>? = null

    private var kind: Output<Kind>? = null

    private var managerName: Output<String>? = null

    private var portalCertificateThumbprint: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Represents the encryption algorithm used to encrypt the keys. None - if Key is saved in plain text format. Algorithm name - if key is encrypted
     */
    @JvmName("diwseenmrxdcpwfy")
    public suspend fun algorithm(`value`: Output<String>) {
        this.algorithm = value
    }

    /**
     * @param value Represents the CEK of the resource.
     */
    @JvmName("eadnfdhnehpbmkfq")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value Represents the Cert thumbprint that was used to encrypt the CEK.
     */
    @JvmName("bnmqtfdfcbvwjehh")
    public suspend fun encryptionKeyThumbprint(`value`: Output<String>) {
        this.encryptionKeyThumbprint = value
    }

    /**
     * @param value Represents the CIK of the resource.
     */
    @JvmName("xytuecjhxtkdnieh")
    public suspend fun integrityKey(`value`: Output<String>) {
        this.integrityKey = value
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("bhwswuuxtouedfsr")
    public suspend fun kind(`value`: Output<Kind>) {
        this.kind = value
    }

    /**
     * @param value The manager name
     */
    @JvmName("qxtuuhnsnhysnlia")
    public suspend fun managerName(`value`: Output<String>) {
        this.managerName = value
    }

    /**
     * @param value Represents the portal thumbprint which can be used optionally to encrypt the entire data before storing it.
     */
    @JvmName("ntjirbckbyulnpyr")
    public suspend fun portalCertificateThumbprint(`value`: Output<String>) {
        this.portalCertificateThumbprint = value
    }

    /**
     * @param value The resource group name
     */
    @JvmName("lcjkeucnemihupqn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The version of the extended info being persisted.
     */
    @JvmName("cwtkrhomxlmtteea")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Represents the encryption algorithm used to encrypt the keys. None - if Key is saved in plain text format. Algorithm name - if key is encrypted
     */
    @JvmName("eoqqwiccmffdqpio")
    public suspend fun algorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.algorithm = mapped
    }

    /**
     * @param value Represents the CEK of the resource.
     */
    @JvmName("gqixgypgmwucnpvm")
    public suspend fun encryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value Represents the Cert thumbprint that was used to encrypt the CEK.
     */
    @JvmName("mrqfiekosysbkyct")
    public suspend fun encryptionKeyThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKeyThumbprint = mapped
    }

    /**
     * @param value Represents the CIK of the resource.
     */
    @JvmName("qwlktidxkebflsln")
    public suspend fun integrityKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrityKey = mapped
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("bmjnjajvgdgvxlla")
    public suspend fun kind(`value`: Kind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("qwbadvrjrvklpylx")
    public suspend fun managerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managerName = mapped
    }

    /**
     * @param value Represents the portal thumbprint which can be used optionally to encrypt the entire data before storing it.
     */
    @JvmName("lkvjrnewnrmschfp")
    public suspend fun portalCertificateThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portalCertificateThumbprint = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("yofnvvcmlrqimaxi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The version of the extended info being persisted.
     */
    @JvmName("vagbaqmwvvxfodon")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ManagerExtendedInfoArgs = ManagerExtendedInfoArgs(
        algorithm = algorithm,
        encryptionKey = encryptionKey,
        encryptionKeyThumbprint = encryptionKeyThumbprint,
        integrityKey = integrityKey,
        kind = kind,
        managerName = managerName,
        portalCertificateThumbprint = portalCertificateThumbprint,
        resourceGroupName = resourceGroupName,
        version = version,
    )
}
