@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.GetAccessControlRecordPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessControlRecordName Name of access control record to be fetched.
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 */
public data class GetAccessControlRecordPlainArgs(
    public val accessControlRecordName: String,
    public val managerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.GetAccessControlRecordPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.GetAccessControlRecordPlainArgs =
        com.pulumi.azurenative.storsimple.inputs.GetAccessControlRecordPlainArgs.builder()
            .accessControlRecordName(accessControlRecordName.let({ args0 -> args0 }))
            .managerName(managerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessControlRecordPlainArgs].
 */
@PulumiTagMarker
public class GetAccessControlRecordPlainArgsBuilder internal constructor() {
    private var accessControlRecordName: String? = null

    private var managerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of access control record to be fetched.
     */
    @JvmName("mdighksmsnrthsgf")
    public suspend fun accessControlRecordName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessControlRecordName = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("jqpsclfqwdqjqcio")
    public suspend fun managerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("twsmjikmqxcbedmw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAccessControlRecordPlainArgs = GetAccessControlRecordPlainArgs(
        accessControlRecordName = accessControlRecordName ?: throw
            PulumiNullFieldException("accessControlRecordName"),
        managerName = managerName ?: throw PulumiNullFieldException("managerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
