@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.GetStorageAccountCredentialPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 * @property storageAccountCredentialName The name of storage account credential to be fetched.
 */
public data class GetStorageAccountCredentialPlainArgs(
    public val managerName: String,
    public val resourceGroupName: String,
    public val storageAccountCredentialName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.GetStorageAccountCredentialPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.storsimple.inputs.GetStorageAccountCredentialPlainArgs =
        com.pulumi.azurenative.storsimple.inputs.GetStorageAccountCredentialPlainArgs.builder()
            .managerName(managerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageAccountCredentialName(storageAccountCredentialName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageAccountCredentialPlainArgs].
 */
@PulumiTagMarker
public class GetStorageAccountCredentialPlainArgsBuilder internal constructor() {
    private var managerName: String? = null

    private var resourceGroupName: String? = null

    private var storageAccountCredentialName: String? = null

    /**
     * @param value The manager name
     */
    @JvmName("hqroeffqpegfyddv")
    public suspend fun managerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("nxdpcmhmlmmhrfht")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of storage account credential to be fetched.
     */
    @JvmName("xldsxrfupbysljkd")
    public suspend fun storageAccountCredentialName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageAccountCredentialName = mapped
    }

    internal fun build(): GetStorageAccountCredentialPlainArgs = GetStorageAccountCredentialPlainArgs(
        managerName = managerName ?: throw PulumiNullFieldException("managerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageAccountCredentialName = storageAccountCredentialName ?: throw
            PulumiNullFieldException("storageAccountCredentialName"),
    )
}
