@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.ManagerIntrinsicSettingsArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.ManagerType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Intrinsic settings which refers to the type of the StorSimple Manager.
 * @property type The type of StorSimple Manager.
 */
public data class ManagerIntrinsicSettingsArgs(
    public val type: Output<ManagerType>,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.ManagerIntrinsicSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.ManagerIntrinsicSettingsArgs =
        com.pulumi.azurenative.storsimple.inputs.ManagerIntrinsicSettingsArgs.builder()
            .type(type.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ManagerIntrinsicSettingsArgs].
 */
@PulumiTagMarker
public class ManagerIntrinsicSettingsArgsBuilder internal constructor() {
    private var type: Output<ManagerType>? = null

    /**
     * @param value The type of StorSimple Manager.
     */
    @JvmName("iauoofnhbwfonqxr")
    public suspend fun type(`value`: Output<ManagerType>) {
        this.type = value
    }

    /**
     * @param value The type of StorSimple Manager.
     */
    @JvmName("ffyxvoqsqranuukw")
    public suspend fun type(`value`: ManagerType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ManagerIntrinsicSettingsArgs = ManagerIntrinsicSettingsArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
