@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.ManagerSkuArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.ManagerSkuType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Sku.
 * @property name Refers to the sku name which should be "Standard"
 */
public data class ManagerSkuArgs(
    public val name: Output<ManagerSkuType>,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.ManagerSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.ManagerSkuArgs =
        com.pulumi.azurenative.storsimple.inputs.ManagerSkuArgs.builder()
            .name(name.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ManagerSkuArgs].
 */
@PulumiTagMarker
public class ManagerSkuArgsBuilder internal constructor() {
    private var name: Output<ManagerSkuType>? = null

    /**
     * @param value Refers to the sku name which should be "Standard"
     */
    @JvmName("stxhqlvqlnklkpye")
    public suspend fun name(`value`: Output<ManagerSkuType>) {
        this.name = value
    }

    /**
     * @param value Refers to the sku name which should be "Standard"
     */
    @JvmName("audwlsquojilxdgp")
    public suspend fun name(`value`: ManagerSkuType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ManagerSkuArgs = ManagerSkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
