@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The failover set on a device.
 * @property eligibilityResult The eligibility result of the failover set, for failover.
 * @property volumeContainers The list of meta data of volume containers, which are part of the failover set.
 */
public data class FailoverSetResponse(
    public val eligibilityResult: FailoverSetEligibilityResultResponse? = null,
    public val volumeContainers: List<VolumeContainerFailoverMetadataResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.FailoverSetResponse):
            FailoverSetResponse = FailoverSetResponse(
            eligibilityResult = javaType.eligibilityResult().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storsimple.kotlin.outputs.FailoverSetEligibilityResultResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            volumeContainers = javaType.volumeContainers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storsimple.kotlin.outputs.VolumeContainerFailoverMetadataResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
