@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The backup policy.
 * @property backupPolicyCreationType The backup policy creation type. Indicates whether this was created through SaaS or through StorSimple Snapshot Manager.
 * @property id The path ID that uniquely identifies the object.
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property lastBackupTime The time of the last backup for the backup policy.
 * @property name The name of the object.
 * @property nextBackupTime The time of the next backup for the backup policy.
 * @property scheduledBackupStatus Indicates whether at least one of the schedules in the backup policy is active or not.
 * @property schedulesCount The count of schedules the backup policy contains.
 * @property ssmHostName If the backup policy was created by StorSimple Snapshot Manager, then this field indicates the hostname of the StorSimple Snapshot Manager.
 * @property type The hierarchical type of the object.
 * @property volumeIds The path IDs of the volumes which are part of the backup policy.
 */
public data class GetBackupPolicyResult(
    public val backupPolicyCreationType: String,
    public val id: String,
    public val kind: String? = null,
    public val lastBackupTime: String,
    public val name: String,
    public val nextBackupTime: String,
    public val scheduledBackupStatus: String,
    public val schedulesCount: Double,
    public val ssmHostName: String,
    public val type: String,
    public val volumeIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.GetBackupPolicyResult):
            GetBackupPolicyResult = GetBackupPolicyResult(
            backupPolicyCreationType = javaType.backupPolicyCreationType(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            lastBackupTime = javaType.lastBackupTime(),
            name = javaType.name(),
            nextBackupTime = javaType.nextBackupTime(),
            scheduledBackupStatus = javaType.scheduledBackupStatus(),
            schedulesCount = javaType.schedulesCount(),
            ssmHostName = javaType.ssmHostName(),
            type = javaType.type(),
            volumeIds = javaType.volumeIds().map({ args0 -> args0 }),
        )
    }
}
