@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The volume.
 * @property accessControlRecordIds The IDs of the access control records, associated with the volume.
 * @property backupPolicyIds The IDs of the backup policies, in which this volume is part of.
 * @property backupStatus The backup status of the volume.
 * @property id The path ID that uniquely identifies the object.
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property monitoringStatus The monitoring status of the volume.
 * @property name The name of the object.
 * @property operationStatus The operation status on the volume.
 * @property sizeInBytes The size of the volume in bytes.
 * @property type The hierarchical type of the object.
 * @property volumeContainerId The ID of the volume container, in which this volume is created.
 * @property volumeStatus The volume status.
 * @property volumeType The type of the volume.
 */
public data class GetVolumeResult(
    public val accessControlRecordIds: List<String>,
    public val backupPolicyIds: List<String>,
    public val backupStatus: String,
    public val id: String,
    public val kind: String? = null,
    public val monitoringStatus: String,
    public val name: String,
    public val operationStatus: String,
    public val sizeInBytes: Double,
    public val type: String,
    public val volumeContainerId: String,
    public val volumeStatus: String,
    public val volumeType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.GetVolumeResult):
            GetVolumeResult = GetVolumeResult(
            accessControlRecordIds = javaType.accessControlRecordIds().map({ args0 -> args0 }),
            backupPolicyIds = javaType.backupPolicyIds().map({ args0 -> args0 }),
            backupStatus = javaType.backupStatus(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            monitoringStatus = javaType.monitoringStatus(),
            name = javaType.name(),
            operationStatus = javaType.operationStatus(),
            sizeInBytes = javaType.sizeInBytes(),
            type = javaType.type(),
            volumeContainerId = javaType.volumeContainerId(),
            volumeStatus = javaType.volumeStatus(),
            volumeType = javaType.volumeType(),
        )
    }
}
