@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The eligibility result of device, as a failover target device.
 * @property eligibilityStatus The eligibility status of device, as a failover target device.
 * @property messages The list of error messages, if a device does not qualify as a failover target device.
 */
public data class TargetEligibilityResultResponse(
    public val eligibilityStatus: String? = null,
    public val messages: List<TargetEligibilityErrorMessageResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.TargetEligibilityResultResponse):
            TargetEligibilityResultResponse = TargetEligibilityResultResponse(
            eligibilityStatus = javaType.eligibilityStatus().map({ args0 -> args0 }).orElse(null),
            messages = javaType.messages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storsimple.kotlin.outputs.TargetEligibilityErrorMessageResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
