@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin

import com.pulumi.azurenative.streamanalytics.ClusterArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.ClusterSkuArgs
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.ClusterSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Stream Analytics Cluster object
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2020-03-01-preview.
 * Other available API versions: 2020-03-01-preview.
 * ## Example Usage
 * ### Create a new cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.StreamAnalytics.Cluster("cluster", new()
 *     {
 *         ClusterName = "An Example Cluster",
 *         Location = "North US",
 *         ResourceGroupName = "sjrg",
 *         Sku = new AzureNative.StreamAnalytics.Inputs.ClusterSkuArgs
 *         {
 *             Capacity = 48,
 *             Name = "Default",
 *         },
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewCluster(ctx, "cluster", &streamanalytics.ClusterArgs{
 * 			ClusterName:       pulumi.String("An Example Cluster"),
 * 			Location:          pulumi.String("North US"),
 * 			ResourceGroupName: pulumi.String("sjrg"),
 * 			Sku: &streamanalytics.ClusterSkuArgs{
 * 				Capacity: pulumi.Int(48),
 * 				Name:     pulumi.String("Default"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Cluster;
 * import com.pulumi.azurenative.streamanalytics.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("An Example Cluster")
 *             .location("North US")
 *             .resourceGroupName("sjrg")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 48),
 *                 Map.entry("name", "Default")
 *             ))
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:streamanalytics:Cluster An Example Cluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/clusters/{clusterName}
 * ```
 * @property clusterName The name of the cluster.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.
 * @property tags Resource tags.
 */
public data class ClusterArgs(
    public val clusterName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ClusterSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.ClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.ClusterArgs =
        com.pulumi.azurenative.streamanalytics.ClusterArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ClusterSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("tunslhmnulgeseij")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ytfjjiopgtpyjplo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jvfrrcijovijlhgg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("kcelmesexdsxohch")
    public suspend fun sku(`value`: Output<ClusterSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("amjddajaihkeiemg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("avhagavrtxfxxpfi")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("unnauspqbveubysv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fjvlfusfubgpscuf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("qxnnqixrpsthsehl")
    public suspend fun sku(`value`: ClusterSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.
     */
    @JvmName("vgoprspeqltudapq")
    public suspend fun sku(argument: suspend ClusterSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xocestnxnwhomnwk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jisjykdlmvqnvfwq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        clusterName = clusterName,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
