@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin

import com.pulumi.azurenative.streamanalytics.kotlin.outputs.DiagnosticsResponse
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.DiagnosticsResponse.Companion.toKotlin
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Output].
 */
@PulumiTagMarker
public class OutputResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OutputArgs = OutputArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OutputArgsBuilder.() -> Unit) {
        val builder = OutputArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Output {
        val builtJavaResource = com.pulumi.azurenative.streamanalytics.Output(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Output(builtJavaResource)
    }
}

/**
 * An output object, containing all information associated with the named output. All outputs are contained under a streaming job.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * Other available API versions: 2021-10-01-preview.
 * ## Example Usage
 * ### Create a DocumentDB output
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var output = new AzureNative.StreamAnalytics.Output("output", new()
 *     {
 *         Datasource = new AzureNative.StreamAnalytics.Inputs.DocumentDbOutputDataSourceArgs
 *         {
 *             AccountId = "someAccountId",
 *             AccountKey = "accountKey==",
 *             CollectionNamePattern = "collection",
 *             Database = "db01",
 *             DocumentId = "documentId",
 *             PartitionKey = "key",
 *             Type = "Microsoft.Storage/DocumentDB",
 *         },
 *         JobName = "sj2331",
 *         OutputName = "output3022",
 *         ResourceGroupName = "sjrg7983",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewOutput(ctx, "output", &streamanalytics.OutputArgs{
 * 			Datasource: streamanalytics.DocumentDbOutputDataSource{
 * 				AccountId:             "someAccountId",
 * 				AccountKey:            "accountKey==",
 * 				CollectionNamePattern: "collection",
 * 				Database:              "db01",
 * 				DocumentId:            "documentId",
 * 				PartitionKey:          "key",
 * 				Type:                  "Microsoft.Storage/DocumentDB",
 * 			},
 * 			JobName:           pulumi.String("sj2331"),
 * 			OutputName:        pulumi.String("output3022"),
 * 			ResourceGroupName: pulumi.String("sjrg7983"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Output;
 * import com.pulumi.azurenative.streamanalytics.OutputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var output = new Output("output", OutputArgs.builder()
 *             .datasource(Map.ofEntries(
 *                 Map.entry("accountId", "someAccountId"),
 *                 Map.entry("accountKey", "accountKey=="),
 *                 Map.entry("collectionNamePattern", "collection"),
 *                 Map.entry("database", "db01"),
 *                 Map.entry("documentId", "documentId"),
 *                 Map.entry("partitionKey", "key"),
 *                 Map.entry("type", "Microsoft.Storage/DocumentDB")
 *             ))
 *             .jobName("sj2331")
 *             .outputName("output3022")
 *             .resourceGroupName("sjrg7983")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Gateway Message Bus output
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var output = new AzureNative.StreamAnalytics.Output("output", new()
 *     {
 *         Datasource = new AzureNative.StreamAnalytics.Inputs.GatewayMessageBusOutputDataSourceArgs
 *         {
 *             Topic = "EdgeTopic1",
 *             Type = "GatewayMessageBus",
 *         },
 *         JobName = "sj2331",
 *         OutputName = "output3022",
 *         ResourceGroupName = "sjrg7983",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewOutput(ctx, "output", &streamanalytics.OutputArgs{
 * 			Datasource: streamanalytics.GatewayMessageBusOutputDataSource{
 * 				Topic: "EdgeTopic1",
 * 				Type:  "GatewayMessageBus",
 * 			},
 * 			JobName:           pulumi.String("sj2331"),
 * 			OutputName:        pulumi.String("output3022"),
 * 			ResourceGroupName: pulumi.String("sjrg7983"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Output;
 * import com.pulumi.azurenative.streamanalytics.OutputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var output = new Output("output", OutputArgs.builder()
 *             .datasource(Map.ofEntries(
 *                 Map.entry("topic", "EdgeTopic1"),
 *                 Map.entry("type", "GatewayMessageBus")
 *             ))
 *             .jobName("sj2331")
 *             .outputName("output3022")
 *             .resourceGroupName("sjrg7983")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Power BI output
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var output = new AzureNative.StreamAnalytics.Output("output", new()
 *     {
 *         Datasource = new AzureNative.StreamAnalytics.Inputs.PowerBIOutputDataSourceArgs
 *         {
 *             Dataset = "someDataset",
 *             GroupId = "ac40305e-3e8d-43ac-8161-c33799f43e95",
 *             GroupName = "MyPowerBIGroup",
 *             RefreshToken = "someRefreshToken==",
 *             Table = "someTable",
 *             TokenUserDisplayName = "Bob Smith",
 *             TokenUserPrincipalName = "bobsmith@contoso.com",
 *             Type = "PowerBI",
 *         },
 *         JobName = "sj2331",
 *         OutputName = "output3022",
 *         ResourceGroupName = "sjrg7983",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewOutput(ctx, "output", &streamanalytics.OutputArgs{
 * 			Datasource: streamanalytics.PowerBIOutputDataSource{
 * 				Dataset:                "someDataset",
 * 				GroupId:                "ac40305e-3e8d-43ac-8161-c33799f43e95",
 * 				GroupName:              "MyPowerBIGroup",
 * 				RefreshToken:           "someRefreshToken==",
 * 				Table:                  "someTable",
 * 				TokenUserDisplayName:   "Bob Smith",
 * 				TokenUserPrincipalName: "bobsmith@contoso.com",
 * 				Type:                   "PowerBI",
 * 			},
 * 			JobName:           pulumi.String("sj2331"),
 * 			OutputName:        pulumi.String("output3022"),
 * 			ResourceGroupName: pulumi.String("sjrg7983"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Output;
 * import com.pulumi.azurenative.streamanalytics.OutputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var output = new Output("output", OutputArgs.builder()
 *             .datasource(Map.ofEntries(
 *                 Map.entry("dataset", "someDataset"),
 *                 Map.entry("groupId", "ac40305e-3e8d-43ac-8161-c33799f43e95"),
 *                 Map.entry("groupName", "MyPowerBIGroup"),
 *                 Map.entry("refreshToken", "someRefreshToken=="),
 *                 Map.entry("table", "someTable"),
 *                 Map.entry("tokenUserDisplayName", "Bob Smith"),
 *                 Map.entry("tokenUserPrincipalName", "bobsmith@contoso.com"),
 *                 Map.entry("type", "PowerBI")
 *             ))
 *             .jobName("sj2331")
 *             .outputName("output3022")
 *             .resourceGroupName("sjrg7983")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Service Bus Queue output with Avro serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var output = new AzureNative.StreamAnalytics.Output("output", new()
 *     {
 *         Datasource = new AzureNative.StreamAnalytics.Inputs.ServiceBusQueueOutputDataSourceArgs
 *         {
 *             PropertyColumns = new[]
 *             {
 *                 "column1",
 *                 "column2",
 *             },
 *             QueueName = "sdkqueue",
 *             ServiceBusNamespace = "sdktest",
 *             SharedAccessPolicyKey = "sharedAccessPolicyKey=",
 *             SharedAccessPolicyName = "RootManageSharedAccessKey",
 *             SystemPropertyColumns =
 *             {
 *                 { "MessageId", "col3" },
 *                 { "PartitionKey", "col4" },
 *             },
 *             Type = "Microsoft.ServiceBus/Queue",
 *         },
 *         JobName = "sj5095",
 *         OutputName = "output3456",
 *         ResourceGroupName = "sjrg3410",
 *         Serialization = new AzureNative.StreamAnalytics.Inputs.AvroSerializationArgs
 *         {
 *             Type = "Avro",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewOutput(ctx, "output", &streamanalytics.OutputArgs{
 * 			Datasource: streamanalytics.ServiceBusQueueOutputDataSource{
 * 				PropertyColumns: []string{
 * 					"column1",
 * 					"column2",
 * 				},
 * 				QueueName:              "sdkqueue",
 * 				ServiceBusNamespace:    "sdktest",
 * 				SharedAccessPolicyKey:  "sharedAccessPolicyKey=",
 * 				SharedAccessPolicyName: "RootManageSharedAccessKey",
 * 				SystemPropertyColumns: map[string]interface{}{
 * 					"MessageId":    "col3",
 * 					"PartitionKey": "col4",
 * 				},
 * 				Type: "Microsoft.ServiceBus/Queue",
 * 			},
 * 			JobName:           pulumi.String("sj5095"),
 * 			OutputName:        pulumi.String("output3456"),
 * 			ResourceGroupName: pulumi.String("sjrg3410"),
 * 			Serialization: streamanalytics.AvroSerialization{
 * 				Type: "Avro",
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Output;
 * import com.pulumi.azurenative.streamanalytics.OutputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var output = new Output("output", OutputArgs.builder()
 *             .datasource(Map.ofEntries(
 *                 Map.entry("propertyColumns",
 *                     "column1",
 *                     "column2"),
 *                 Map.entry("queueName", "sdkqueue"),
 *                 Map.entry("serviceBusNamespace", "sdktest"),
 *                 Map.entry("sharedAccessPolicyKey", "sharedAccessPolicyKey="),
 *                 Map.entry("sharedAccessPolicyName", "RootManageSharedAccessKey"),
 *                 Map.entry("systemPropertyColumns", AzureDataLakeStoreOutputDataSourceArgs.builder()
 *                     .messageId("col3")
 *                     .partitionKey("col4")
 *                     .build()),
 *                 Map.entry("type", "Microsoft.ServiceBus/Queue")
 *             ))
 *             .jobName("sj5095")
 *             .outputName("output3456")
 *             .resourceGroupName("sjrg3410")
 *             .serialization(Map.of("type", "Avro"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Service Bus Topic output with CSV serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var output = new AzureNative.StreamAnalytics.Output("output", new()
 *     {
 *         Datasource = new AzureNative.StreamAnalytics.Inputs.ServiceBusTopicOutputDataSourceArgs
 *         {
 *             PropertyColumns = new[]
 *             {
 *                 "column1",
 *                 "column2",
 *             },
 *             ServiceBusNamespace = "sdktest",
 *             SharedAccessPolicyKey = "sharedAccessPolicyKey=",
 *             SharedAccessPolicyName = "RootManageSharedAccessKey",
 *             TopicName = "sdktopic",
 *             Type = "Microsoft.ServiceBus/Topic",
 *         },
 *         JobName = "sj7094",
 *         OutputName = "output7886",
 *         ResourceGroupName = "sjrg6450",
 *         Serialization = new AzureNative.StreamAnalytics.Inputs.CsvSerializationArgs
 *         {
 *             Encoding = "UTF8",
 *             FieldDelimiter = ",",
 *             Type = "Csv",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewOutput(ctx, "output", &streamanalytics.OutputArgs{
 * 			Datasource: streamanalytics.ServiceBusTopicOutputDataSource{
 * 				PropertyColumns: []string{
 * 					"column1",
 * 					"column2",
 * 				},
 * 				ServiceBusNamespace:    "sdktest",
 * 				SharedAccessPolicyKey:  "sharedAccessPolicyKey=",
 * 				SharedAccessPolicyName: "RootManageSharedAccessKey",
 * 				TopicName:              "sdktopic",
 * 				Type:                   "Microsoft.ServiceBus/Topic",
 * 			},
 * 			JobName:           pulumi.String("sj7094"),
 * 			OutputName:        pulumi.String("output7886"),
 * 			ResourceGroupName: pulumi.String("sjrg6450"),
 * 			Serialization: streamanalytics.CsvSerialization{
 * 				Encoding:       "UTF8",
 * 				FieldDelimiter: ",",
 * 				Type:           "Csv",
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Output;
 * import com.pulumi.azurenative.streamanalytics.OutputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var output = new Output("output", OutputArgs.builder()
 *             .datasource(Map.ofEntries(
 *                 Map.entry("propertyColumns",
 *                     "column1",
 *                     "column2"),
 *                 Map.entry("serviceBusNamespace", "sdktest"),
 *                 Map.entry("sharedAccessPolicyKey", "sharedAccessPolicyKey="),
 *                 Map.entry("sharedAccessPolicyName", "RootManageSharedAccessKey"),
 *                 Map.entry("topicName", "sdktopic"),
 *                 Map.entry("type", "Microsoft.ServiceBus/Topic")
 *             ))
 *             .jobName("sj7094")
 *             .outputName("output7886")
 *             .resourceGroupName("sjrg6450")
 *             .serialization(Map.ofEntries(
 *                 Map.entry("encoding", "UTF8"),
 *                 Map.entry("fieldDelimiter", ","),
 *                 Map.entry("type", "Csv")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a blob output with CSV serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var output = new AzureNative.StreamAnalytics.Output("output", new()
 *     {
 *         Datasource = new AzureNative.StreamAnalytics.Inputs.BlobOutputDataSourceArgs
 *         {
 *             Container = "state",
 *             DateFormat = "yyyy/MM/dd",
 *             PathPattern = "{date}/{time}",
 *             StorageAccounts = new[]
 *             {
 *                 new AzureNative.StreamAnalytics.Inputs.StorageAccountArgs
 *                 {
 *                     AccountKey = "accountKey==",
 *                     AccountName = "someAccountName",
 *                 },
 *             },
 *             TimeFormat = "HH",
 *             Type = "Microsoft.Storage/Blob",
 *         },
 *         JobName = "sj900",
 *         OutputName = "output1623",
 *         ResourceGroupName = "sjrg5023",
 *         Serialization = new AzureNative.StreamAnalytics.Inputs.CsvSerializationArgs
 *         {
 *             Encoding = "UTF8",
 *             FieldDelimiter = ",",
 *             Type = "Csv",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewOutput(ctx, "output", &streamanalytics.OutputArgs{
 * 			Datasource: streamanalytics.BlobOutputDataSource{
 * 				Container:   "state",
 * 				DateFormat:  "yyyy/MM/dd",
 * 				PathPattern: "{date}/{time}",
 * 				StorageAccounts: []streamanalytics.StorageAccount{
 * 					{
 * 						AccountKey:  "accountKey==",
 * 						AccountName: "someAccountName",
 * 					},
 * 				},
 * 				TimeFormat: "HH",
 * 				Type:       "Microsoft.Storage/Blob",
 * 			},
 * 			JobName:           pulumi.String("sj900"),
 * 			OutputName:        pulumi.String("output1623"),
 * 			ResourceGroupName: pulumi.String("sjrg5023"),
 * 			Serialization: streamanalytics.CsvSerialization{
 * 				Encoding:       "UTF8",
 * 				FieldDelimiter: ",",
 * 				Type:           "Csv",
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Output;
 * import com.pulumi.azurenative.streamanalytics.OutputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var output = new Output("output", OutputArgs.builder()
 *             .datasource(Map.ofEntries(
 *                 Map.entry("container", "state"),
 *                 Map.entry("dateFormat", "yyyy/MM/dd"),
 *                 Map.entry("pathPattern", "{date}/{time}"),
 *                 Map.entry("storageAccounts", Map.ofEntries(
 *                     Map.entry("accountKey", "accountKey=="),
 *                     Map.entry("accountName", "someAccountName")
 *                 )),
 *                 Map.entry("timeFormat", "HH"),
 *                 Map.entry("type", "Microsoft.Storage/Blob")
 *             ))
 *             .jobName("sj900")
 *             .outputName("output1623")
 *             .resourceGroupName("sjrg5023")
 *             .serialization(Map.ofEntries(
 *                 Map.entry("encoding", "UTF8"),
 *                 Map.entry("fieldDelimiter", ","),
 *                 Map.entry("type", "Csv")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Azure Data Lake Store output with JSON serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var output = new AzureNative.StreamAnalytics.Output("output", new()
 *     {
 *         Datasource = new AzureNative.StreamAnalytics.Inputs.AzureDataLakeStoreOutputDataSourceArgs
 *         {
 *             AccountName = "someaccount",
 *             DateFormat = "yyyy/MM/dd",
 *             FilePathPrefix = "{date}/{time}",
 *             RefreshToken = "someRefreshToken==",
 *             TenantId = "cea4e98b-c798-49e7-8c40-4a2b3beb47dd",
 *             TimeFormat = "HH",
 *             TokenUserDisplayName = "Bob Smith",
 *             TokenUserPrincipalName = "bobsmith@contoso.com",
 *             Type = "Microsoft.DataLake/Accounts",
 *         },
 *         JobName = "sj3310",
 *         OutputName = "output5195",
 *         ResourceGroupName = "sjrg6912",
 *         Serialization = new AzureNative.StreamAnalytics.Inputs.JsonSerializationArgs
 *         {
 *             Encoding = "UTF8",
 *             Format = "Array",
 *             Type = "Json",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewOutput(ctx, "output", &streamanalytics.OutputArgs{
 * 			Datasource: streamanalytics.AzureDataLakeStoreOutputDataSource{
 * 				AccountName:            "someaccount",
 * 				DateFormat:             "yyyy/MM/dd",
 * 				FilePathPrefix:         "{date}/{time}",
 * 				RefreshToken:           "someRefreshToken==",
 * 				TenantId:               "cea4e98b-c798-49e7-8c40-4a2b3beb47dd",
 * 				TimeFormat:             "HH",
 * 				TokenUserDisplayName:   "Bob Smith",
 * 				TokenUserPrincipalName: "bobsmith@contoso.com",
 * 				Type:                   "Microsoft.DataLake/Accounts",
 * 			},
 * 			JobName:           pulumi.String("sj3310"),
 * 			OutputName:        pulumi.String("output5195"),
 * 			ResourceGroupName: pulumi.String("sjrg6912"),
 * 			Serialization: streamanalytics.JsonSerialization{
 * 				Encoding: "UTF8",
 * 				Format:   "Array",
 * 				Type:     "Json",
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Output;
 * import com.pulumi.azurenative.streamanalytics.OutputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var output = new Output("output", OutputArgs.builder()
 *             .datasource(Map.ofEntries(
 *                 Map.entry("accountName", "someaccount"),
 *                 Map.entry("dateFormat", "yyyy/MM/dd"),
 *                 Map.entry("filePathPrefix", "{date}/{time}"),
 *                 Map.entry("refreshToken", "someRefreshToken=="),
 *                 Map.entry("tenantId", "cea4e98b-c798-49e7-8c40-4a2b3beb47dd"),
 *                 Map.entry("timeFormat", "HH"),
 *                 Map.entry("tokenUserDisplayName", "Bob Smith"),
 *                 Map.entry("tokenUserPrincipalName", "bobsmith@contoso.com"),
 *                 Map.entry("type", "Microsoft.DataLake/Accounts")
 *             ))
 *             .jobName("sj3310")
 *             .outputName("output5195")
 *             .resourceGroupName("sjrg6912")
 *             .serialization(Map.ofEntries(
 *                 Map.entry("encoding", "UTF8"),
 *                 Map.entry("format", "Array"),
 *                 Map.entry("type", "Json")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Azure Data Warehouse output
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var output = new AzureNative.StreamAnalytics.Output("output", new()
 *     {
 *         Datasource = new AzureNative.StreamAnalytics.Inputs.AzureSynapseOutputDataSourceArgs
 *         {
 *             Database = "zhayaSQLpool",
 *             Password = "password123",
 *             Server = "asatestserver",
 *             Table = "test2",
 *             Type = "Microsoft.Sql/Server/DataWarehouse",
 *             User = "tolladmin",
 *         },
 *         JobName = "sjName",
 *         OutputName = "dwOutput",
 *         ResourceGroupName = "sjrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewOutput(ctx, "output", &streamanalytics.OutputArgs{
 * 			Datasource: streamanalytics.AzureSynapseOutputDataSource{
 * 				Database: "zhayaSQLpool",
 * 				Password: "password123",
 * 				Server:   "asatestserver",
 * 				Table:    "test2",
 * 				Type:     "Microsoft.Sql/Server/DataWarehouse",
 * 				User:     "tolladmin",
 * 			},
 * 			JobName:           pulumi.String("sjName"),
 * 			OutputName:        pulumi.String("dwOutput"),
 * 			ResourceGroupName: pulumi.String("sjrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Output;
 * import com.pulumi.azurenative.streamanalytics.OutputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var output = new Output("output", OutputArgs.builder()
 *             .datasource(Map.ofEntries(
 *                 Map.entry("database", "zhayaSQLpool"),
 *                 Map.entry("password", "password123"),
 *                 Map.entry("server", "asatestserver"),
 *                 Map.entry("table", "test2"),
 *                 Map.entry("type", "Microsoft.Sql/Server/DataWarehouse"),
 *                 Map.entry("user", "tolladmin")
 *             ))
 *             .jobName("sjName")
 *             .outputName("dwOutput")
 *             .resourceGroupName("sjrg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Azure Function output
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var output = new AzureNative.StreamAnalytics.Output("output", new()
 *     {
 *         Datasource = new AzureNative.StreamAnalytics.Inputs.AzureFunctionOutputDataSourceArgs
 *         {
 *             FunctionAppName = "functionappforasaautomation",
 *             FunctionName = "HttpTrigger2",
 *             MaxBatchCount = 100,
 *             MaxBatchSize = 256,
 *             Type = "Microsoft.AzureFunction",
 *         },
 *         JobName = "sjName",
 *         OutputName = "azureFunction1",
 *         ResourceGroupName = "sjrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewOutput(ctx, "output", &streamanalytics.OutputArgs{
 * 			Datasource: streamanalytics.AzureFunctionOutputDataSource{
 * 				FunctionAppName: "functionappforasaautomation",
 * 				FunctionName:    "HttpTrigger2",
 * 				MaxBatchCount:   100,
 * 				MaxBatchSize:    256,
 * 				Type:            "Microsoft.AzureFunction",
 * 			},
 * 			JobName:           pulumi.String("sjName"),
 * 			OutputName:        pulumi.String("azureFunction1"),
 * 			ResourceGroupName: pulumi.String("sjrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Output;
 * import com.pulumi.azurenative.streamanalytics.OutputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var output = new Output("output", OutputArgs.builder()
 *             .datasource(Map.ofEntries(
 *                 Map.entry("functionAppName", "functionappforasaautomation"),
 *                 Map.entry("functionName", "HttpTrigger2"),
 *                 Map.entry("maxBatchCount", 100),
 *                 Map.entry("maxBatchSize", 256),
 *                 Map.entry("type", "Microsoft.AzureFunction")
 *             ))
 *             .jobName("sjName")
 *             .outputName("azureFunction1")
 *             .resourceGroupName("sjrg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Azure SQL database output
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var output = new AzureNative.StreamAnalytics.Output("output", new()
 *     {
 *         Datasource = new AzureNative.StreamAnalytics.Inputs.AzureSqlDatabaseOutputDataSourceArgs
 *         {
 *             Database = "someDatabase",
 *             Password = "somePassword",
 *             Server = "someServer",
 *             Table = "someTable",
 *             Type = "Microsoft.Sql/Server/Database",
 *             User = "<user>",
 *         },
 *         JobName = "sj6458",
 *         OutputName = "output1755",
 *         ResourceGroupName = "sjrg2157",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewOutput(ctx, "output", &streamanalytics.OutputArgs{
 * 			Datasource: streamanalytics.AzureSqlDatabaseOutputDataSource{
 * 				Database: "someDatabase",
 * 				Password: "somePassword",
 * 				Server:   "someServer",
 * 				Table:    "someTable",
 * 				Type:     "Microsoft.Sql/Server/Database",
 * 				User:     "<user>",
 * 			},
 * 			JobName:           pulumi.String("sj6458"),
 * 			OutputName:        pulumi.String("output1755"),
 * 			ResourceGroupName: pulumi.String("sjrg2157"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Output;
 * import com.pulumi.azurenative.streamanalytics.OutputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var output = new Output("output", OutputArgs.builder()
 *             .datasource(Map.ofEntries(
 *                 Map.entry("database", "someDatabase"),
 *                 Map.entry("password", "somePassword"),
 *                 Map.entry("server", "someServer"),
 *                 Map.entry("table", "someTable"),
 *                 Map.entry("type", "Microsoft.Sql/Server/Database"),
 *                 Map.entry("user", "<user>")
 *             ))
 *             .jobName("sj6458")
 *             .outputName("output1755")
 *             .resourceGroupName("sjrg2157")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Azure Table output
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var output = new AzureNative.StreamAnalytics.Output("output", new()
 *     {
 *         Datasource = new AzureNative.StreamAnalytics.Inputs.AzureTableOutputDataSourceArgs
 *         {
 *             AccountKey = "accountKey==",
 *             AccountName = "someAccountName",
 *             BatchSize = 25,
 *             ColumnsToRemove = new[]
 *             {
 *                 "column1",
 *                 "column2",
 *             },
 *             PartitionKey = "partitionKey",
 *             RowKey = "rowKey",
 *             Table = "samples",
 *             Type = "Microsoft.Storage/Table",
 *         },
 *         JobName = "sj2790",
 *         OutputName = "output958",
 *         ResourceGroupName = "sjrg5176",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewOutput(ctx, "output", &streamanalytics.OutputArgs{
 * 			Datasource: streamanalytics.AzureTableOutputDataSource{
 * 				AccountKey:  "accountKey==",
 * 				AccountName: "someAccountName",
 * 				BatchSize:   25,
 * 				ColumnsToRemove: []string{
 * 					"column1",
 * 					"column2",
 * 				},
 * 				PartitionKey: "partitionKey",
 * 				RowKey:       "rowKey",
 * 				Table:        "samples",
 * 				Type:         "Microsoft.Storage/Table",
 * 			},
 * 			JobName:           pulumi.String("sj2790"),
 * 			OutputName:        pulumi.String("output958"),
 * 			ResourceGroupName: pulumi.String("sjrg5176"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Output;
 * import com.pulumi.azurenative.streamanalytics.OutputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var output = new Output("output", OutputArgs.builder()
 *             .datasource(Map.ofEntries(
 *                 Map.entry("accountKey", "accountKey=="),
 *                 Map.entry("accountName", "someAccountName"),
 *                 Map.entry("batchSize", 25),
 *                 Map.entry("columnsToRemove",
 *                     "column1",
 *                     "column2"),
 *                 Map.entry("partitionKey", "partitionKey"),
 *                 Map.entry("rowKey", "rowKey"),
 *                 Map.entry("table", "samples"),
 *                 Map.entry("type", "Microsoft.Storage/Table")
 *             ))
 *             .jobName("sj2790")
 *             .outputName("output958")
 *             .resourceGroupName("sjrg5176")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Event Hub output with JSON serialization
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var output = new AzureNative.StreamAnalytics.Output("output", new()
 *     {
 *         Datasource = new AzureNative.StreamAnalytics.Inputs.EventHubOutputDataSourceArgs
 *         {
 *             EventHubName = "sdkeventhub",
 *             PartitionKey = "partitionKey",
 *             ServiceBusNamespace = "sdktest",
 *             SharedAccessPolicyKey = "sharedAccessPolicyKey=",
 *             SharedAccessPolicyName = "RootManageSharedAccessKey",
 *             Type = "Microsoft.ServiceBus/EventHub",
 *         },
 *         JobName = "sj3310",
 *         OutputName = "output5195",
 *         ResourceGroupName = "sjrg6912",
 *         Serialization = new AzureNative.StreamAnalytics.Inputs.JsonSerializationArgs
 *         {
 *             Encoding = "UTF8",
 *             Format = "Array",
 *             Type = "Json",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewOutput(ctx, "output", &streamanalytics.OutputArgs{
 * 			Datasource: streamanalytics.EventHubOutputDataSource{
 * 				EventHubName:           "sdkeventhub",
 * 				PartitionKey:           "partitionKey",
 * 				ServiceBusNamespace:    "sdktest",
 * 				SharedAccessPolicyKey:  "sharedAccessPolicyKey=",
 * 				SharedAccessPolicyName: "RootManageSharedAccessKey",
 * 				Type:                   "Microsoft.ServiceBus/EventHub",
 * 			},
 * 			JobName:           pulumi.String("sj3310"),
 * 			OutputName:        pulumi.String("output5195"),
 * 			ResourceGroupName: pulumi.String("sjrg6912"),
 * 			Serialization: streamanalytics.JsonSerialization{
 * 				Encoding: "UTF8",
 * 				Format:   "Array",
 * 				Type:     "Json",
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Output;
 * import com.pulumi.azurenative.streamanalytics.OutputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var output = new Output("output", OutputArgs.builder()
 *             .datasource(Map.ofEntries(
 *                 Map.entry("eventHubName", "sdkeventhub"),
 *                 Map.entry("partitionKey", "partitionKey"),
 *                 Map.entry("serviceBusNamespace", "sdktest"),
 *                 Map.entry("sharedAccessPolicyKey", "sharedAccessPolicyKey="),
 *                 Map.entry("sharedAccessPolicyName", "RootManageSharedAccessKey"),
 *                 Map.entry("type", "Microsoft.ServiceBus/EventHub")
 *             ))
 *             .jobName("sj3310")
 *             .outputName("output5195")
 *             .resourceGroupName("sjrg6912")
 *             .serialization(Map.ofEntries(
 *                 Map.entry("encoding", "UTF8"),
 *                 Map.entry("format", "Array"),
 *                 Map.entry("type", "Json")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:streamanalytics:Output output5195 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/outputs/{outputName}
 * ```
 */
public class Output internal constructor(
    override val javaResource: com.pulumi.azurenative.streamanalytics.Output,
) : KotlinCustomResource(javaResource, OutputMapper) {
    /**
     * Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
     */
    public val datasource: com.pulumi.core.Output<Any>?
        get() = javaResource.datasource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
     */
    public val diagnostics: com.pulumi.core.Output<DiagnosticsResponse>
        get() = javaResource.diagnostics().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The current entity tag for the output. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
     */
    public val etag: com.pulumi.core.Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: com.pulumi.core.Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
     */
    public val serialization: com.pulumi.core.Output<Any>?
        get() = javaResource.serialization().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The size window to constrain a Stream Analytics output to.
     */
    public val sizeWindow: com.pulumi.core.Output<Int>?
        get() = javaResource.sizeWindow().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time frame for filtering Stream Analytics job outputs.
     */
    public val timeWindow: com.pulumi.core.Output<String>?
        get() = javaResource.timeWindow().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: com.pulumi.core.Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OutputMapper : ResourceMapper<Output> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.streamanalytics.Output::class == javaResource::class

    override fun map(javaResource: Resource): Output = Output(
        javaResource as
            com.pulumi.azurenative.streamanalytics.Output,
    )
}

/**
 * @see [Output].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Output].
 */
public suspend fun output(name: String, block: suspend OutputResourceBuilder.() -> Unit): Output {
    val builder = OutputResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Output].
 * @param name The _unique_ name of the resulting resource.
 */
public fun output(name: String): Output {
    val builder = OutputResourceBuilder()
    builder.name(name)
    return builder.build()
}
