@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin

import com.pulumi.azurenative.streamanalytics.kotlin.outputs.PrivateLinkServiceConnectionResponse
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.PrivateLinkServiceConnectionResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [PrivateEndpoint].
 */
@PulumiTagMarker
public class PrivateEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointArgs = PrivateEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateEndpoint {
        val builtJavaResource =
            com.pulumi.azurenative.streamanalytics.PrivateEndpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpoint(builtJavaResource)
    }
}

/**
 * Complete information about the private endpoint.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2020-03-01-preview.
 * Other available API versions: 2020-03-01-preview.
 * ## Example Usage
 * ### Create a private endpoint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpoint = new AzureNative.StreamAnalytics.PrivateEndpoint("privateEndpoint", new()
 *     {
 *         ClusterName = "testcluster",
 *         ManualPrivateLinkServiceConnections = new[]
 *         {
 *             new AzureNative.StreamAnalytics.Inputs.PrivateLinkServiceConnectionArgs
 *             {
 *                 GroupIds = new[]
 *                 {
 *                     "groupIdFromResource",
 *                 },
 *                 PrivateLinkServiceId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls",
 *             },
 *         },
 *         PrivateEndpointName = "testpe",
 *         ResourceGroupName = "sjrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewPrivateEndpoint(ctx, "privateEndpoint", &streamanalytics.PrivateEndpointArgs{
 * 			ClusterName: pulumi.String("testcluster"),
 * 			ManualPrivateLinkServiceConnections: []streamanalytics.PrivateLinkServiceConnectionArgs{
 * 				{
 * 					GroupIds: pulumi.StringArray{
 * 						pulumi.String("groupIdFromResource"),
 * 					},
 * 					PrivateLinkServiceId: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 * 				},
 * 			},
 * 			PrivateEndpointName: pulumi.String("testpe"),
 * 			ResourceGroupName:   pulumi.String("sjrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.PrivateEndpoint;
 * import com.pulumi.azurenative.streamanalytics.PrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpoint = new PrivateEndpoint("privateEndpoint", PrivateEndpointArgs.builder()
 *             .clusterName("testcluster")
 *             .manualPrivateLinkServiceConnections(Map.ofEntries(
 *                 Map.entry("groupIds", "groupIdFromResource"),
 *                 Map.entry("privateLinkServiceId", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls")
 *             ))
 *             .privateEndpointName("testpe")
 *             .resourceGroupName("sjrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:streamanalytics:PrivateEndpoint An Example Private Endpoint /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/clusters/{clusterName}/privateEndpoints/{privateEndpointName}
 * ```
 */
public class PrivateEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.streamanalytics.PrivateEndpoint,
) : KotlinCustomResource(javaResource, PrivateEndpointMapper) {
    /**
     * The date when this private endpoint was created.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Unique opaque string (generally a GUID) that represents the metadata state of the resource (private endpoint) and changes whenever the resource is updated. Required on PUT (CreateOrUpdate) requests.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A list of connections to the remote resource. Immutable after it is set.
     */
    public val manualPrivateLinkServiceConnections:
        Output<List<PrivateLinkServiceConnectionResponse>>?
        get() = javaResource.manualPrivateLinkServiceConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        toKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointMapper : ResourceMapper<PrivateEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.streamanalytics.PrivateEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpoint = PrivateEndpoint(
        javaResource as
            com.pulumi.azurenative.streamanalytics.PrivateEndpoint,
    )
}

/**
 * @see [PrivateEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpoint].
 */
public suspend fun privateEndpoint(
    name: String,
    block: suspend PrivateEndpointResourceBuilder.() -> Unit,
): PrivateEndpoint {
    val builder = PrivateEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpoint(name: String): PrivateEndpoint {
    val builder = PrivateEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
