@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin

import com.pulumi.azurenative.streamanalytics.PrivateEndpointArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.PrivateLinkServiceConnectionArgs
import com.pulumi.azurenative.streamanalytics.kotlin.inputs.PrivateLinkServiceConnectionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Complete information about the private endpoint.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2020-03-01-preview.
 * Other available API versions: 2020-03-01-preview.
 * ## Example Usage
 * ### Create a private endpoint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpoint = new AzureNative.StreamAnalytics.PrivateEndpoint("privateEndpoint", new()
 *     {
 *         ClusterName = "testcluster",
 *         ManualPrivateLinkServiceConnections = new[]
 *         {
 *             new AzureNative.StreamAnalytics.Inputs.PrivateLinkServiceConnectionArgs
 *             {
 *                 GroupIds = new[]
 *                 {
 *                     "groupIdFromResource",
 *                 },
 *                 PrivateLinkServiceId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls",
 *             },
 *         },
 *         PrivateEndpointName = "testpe",
 *         ResourceGroupName = "sjrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewPrivateEndpoint(ctx, "privateEndpoint", &streamanalytics.PrivateEndpointArgs{
 * 			ClusterName: pulumi.String("testcluster"),
 * 			ManualPrivateLinkServiceConnections: []streamanalytics.PrivateLinkServiceConnectionArgs{
 * 				{
 * 					GroupIds: pulumi.StringArray{
 * 						pulumi.String("groupIdFromResource"),
 * 					},
 * 					PrivateLinkServiceId: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 * 				},
 * 			},
 * 			PrivateEndpointName: pulumi.String("testpe"),
 * 			ResourceGroupName:   pulumi.String("sjrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.PrivateEndpoint;
 * import com.pulumi.azurenative.streamanalytics.PrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpoint = new PrivateEndpoint("privateEndpoint", PrivateEndpointArgs.builder()
 *             .clusterName("testcluster")
 *             .manualPrivateLinkServiceConnections(Map.ofEntries(
 *                 Map.entry("groupIds", "groupIdFromResource"),
 *                 Map.entry("privateLinkServiceId", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls")
 *             ))
 *             .privateEndpointName("testpe")
 *             .resourceGroupName("sjrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:streamanalytics:PrivateEndpoint An Example Private Endpoint /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/clusters/{clusterName}/privateEndpoints/{privateEndpointName}
 * ```
 * @property clusterName The name of the cluster.
 * @property manualPrivateLinkServiceConnections A list of connections to the remote resource. Immutable after it is set.
 * @property privateEndpointName The name of the private endpoint.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PrivateEndpointArgs(
    public val clusterName: Output<String>? = null,
    public val manualPrivateLinkServiceConnections: Output<List<PrivateLinkServiceConnectionArgs>>? =
        null,
    public val privateEndpointName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.PrivateEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.PrivateEndpointArgs =
        com.pulumi.azurenative.streamanalytics.PrivateEndpointArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .manualPrivateLinkServiceConnections(
                manualPrivateLinkServiceConnections?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateEndpointName(privateEndpointName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointArgs].
 */
@PulumiTagMarker
public class PrivateEndpointArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var manualPrivateLinkServiceConnections: Output<List<PrivateLinkServiceConnectionArgs>>? =
        null

    private var privateEndpointName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("uwfsxwvegcnaxxds")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value A list of connections to the remote resource. Immutable after it is set.
     */
    @JvmName("ojcupvfialkutrea")
    public suspend
    fun manualPrivateLinkServiceConnections(`value`: Output<List<PrivateLinkServiceConnectionArgs>>) {
        this.manualPrivateLinkServiceConnections = value
    }

    @JvmName("npwtxfybevwprono")
    public suspend fun manualPrivateLinkServiceConnections(
        vararg
        values: Output<PrivateLinkServiceConnectionArgs>,
    ) {
        this.manualPrivateLinkServiceConnections = Output.all(values.asList())
    }

    /**
     * @param values A list of connections to the remote resource. Immutable after it is set.
     */
    @JvmName("rrgnhekldgeguweu")
    public suspend
    fun manualPrivateLinkServiceConnections(values: List<Output<PrivateLinkServiceConnectionArgs>>) {
        this.manualPrivateLinkServiceConnections = Output.all(values)
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("blbiffphooqujevr")
    public suspend fun privateEndpointName(`value`: Output<String>) {
        this.privateEndpointName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("amynkuttxjkqijga")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("yssfvwrjuykkckli")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value A list of connections to the remote resource. Immutable after it is set.
     */
    @JvmName("etinhltlfsrqnodh")
    public suspend
    fun manualPrivateLinkServiceConnections(`value`: List<PrivateLinkServiceConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param argument A list of connections to the remote resource. Immutable after it is set.
     */
    @JvmName("lufikqwiyjkhbhnu")
    public suspend
    fun manualPrivateLinkServiceConnections(argument: List<suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param argument A list of connections to the remote resource. Immutable after it is set.
     */
    @JvmName("yoeiadnmgldsefad")
    public suspend fun manualPrivateLinkServiceConnections(
        vararg
        argument: suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param argument A list of connections to the remote resource. Immutable after it is set.
     */
    @JvmName("uggeankhwigxddim")
    public suspend
    fun manualPrivateLinkServiceConnections(argument: suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param values A list of connections to the remote resource. Immutable after it is set.
     */
    @JvmName("cwqixfsbamlvdnqn")
    public suspend fun manualPrivateLinkServiceConnections(
        vararg
        values: PrivateLinkServiceConnectionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("dknycdoxcvuenbth")
    public suspend fun privateEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tivaknaomlavkdar")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointArgs = PrivateEndpointArgs(
        clusterName = clusterName,
        manualPrivateLinkServiceConnections = manualPrivateLinkServiceConnections,
        privateEndpointName = privateEndpointName,
        resourceGroupName = resourceGroupName,
    )
}
