@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies the format of the JSON the output will be written in. The currently supported values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and 'array' indicating the output will be formatted as an array of JSON objects. Default value is 'lineSeparated' if left null.
 */
public enum class JsonOutputSerializationFormat(
    public val javaValue: com.pulumi.azurenative.streamanalytics.enums.JsonOutputSerializationFormat,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.enums.JsonOutputSerializationFormat> {
    LineSeparated(com.pulumi.azurenative.streamanalytics.enums.JsonOutputSerializationFormat.LineSeparated),
    Array(com.pulumi.azurenative.streamanalytics.enums.JsonOutputSerializationFormat.Array),
    ;

    override fun toJava(): com.pulumi.azurenative.streamanalytics.enums.JsonOutputSerializationFormat =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.enums.JsonOutputSerializationFormat):
            JsonOutputSerializationFormat =
            JsonOutputSerializationFormat.values().first { it.javaValue == javaType }
    }
}
