@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.AvroSerializationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes how data from an input is serialized or how data is serialized when written to an output in Avro format.
 * @property type Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Avro'.
 */
public data class AvroSerializationArgs(
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.AvroSerializationArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.AvroSerializationArgs =
        com.pulumi.azurenative.streamanalytics.inputs.AvroSerializationArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AvroSerializationArgs].
 */
@PulumiTagMarker
public class AvroSerializationArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Avro'.
     */
    @JvmName("hoophwoevpeltiih")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Avro'.
     */
    @JvmName("vxgnpnwuvqluooia")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AvroSerializationArgs = AvroSerializationArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
