@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.AzureFunctionOutputDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the metadata of AzureFunctionOutputDataSource
 * @property apiKey If you want to use an Azure Function from another subscription, you can do so by providing the key to access your function.
 * @property functionAppName The name of your Azure Functions app.
 * @property functionName The name of the function in your Azure Functions app.
 * @property maxBatchCount A property that lets you specify the maximum number of events in each batch that's sent to Azure Functions. The default value is 100.
 * @property maxBatchSize A property that lets you set the maximum size for each output batch that's sent to your Azure function. The input unit is in bytes. By default, this value is 262,144 bytes (256 KB).
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.AzureFunction'.
 */
public data class AzureFunctionOutputDataSourceArgs(
    public val apiKey: Output<String>? = null,
    public val functionAppName: Output<String>? = null,
    public val functionName: Output<String>? = null,
    public val maxBatchCount: Output<Double>? = null,
    public val maxBatchSize: Output<Double>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.AzureFunctionOutputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.AzureFunctionOutputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.AzureFunctionOutputDataSourceArgs.builder()
            .apiKey(apiKey?.applyValue({ args0 -> args0 }))
            .functionAppName(functionAppName?.applyValue({ args0 -> args0 }))
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .maxBatchCount(maxBatchCount?.applyValue({ args0 -> args0 }))
            .maxBatchSize(maxBatchSize?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFunctionOutputDataSourceArgs].
 */
@PulumiTagMarker
public class AzureFunctionOutputDataSourceArgsBuilder internal constructor() {
    private var apiKey: Output<String>? = null

    private var functionAppName: Output<String>? = null

    private var functionName: Output<String>? = null

    private var maxBatchCount: Output<Double>? = null

    private var maxBatchSize: Output<Double>? = null

    private var type: Output<String>? = null

    /**
     * @param value If you want to use an Azure Function from another subscription, you can do so by providing the key to access your function.
     */
    @JvmName("qofgabnvqyfsmktr")
    public suspend fun apiKey(`value`: Output<String>) {
        this.apiKey = value
    }

    /**
     * @param value The name of your Azure Functions app.
     */
    @JvmName("ngxohrwynmpwaalv")
    public suspend fun functionAppName(`value`: Output<String>) {
        this.functionAppName = value
    }

    /**
     * @param value The name of the function in your Azure Functions app.
     */
    @JvmName("xvrlwimttlgvrbvc")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value A property that lets you specify the maximum number of events in each batch that's sent to Azure Functions. The default value is 100.
     */
    @JvmName("babqsgtvjcgulluv")
    public suspend fun maxBatchCount(`value`: Output<Double>) {
        this.maxBatchCount = value
    }

    /**
     * @param value A property that lets you set the maximum size for each output batch that's sent to your Azure function. The input unit is in bytes. By default, this value is 262,144 bytes (256 KB).
     */
    @JvmName("jiyoiqfdgdcmyjru")
    public suspend fun maxBatchSize(`value`: Output<Double>) {
        this.maxBatchSize = value
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.AzureFunction'.
     */
    @JvmName("uhuddhibmxtwrcxl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value If you want to use an Azure Function from another subscription, you can do so by providing the key to access your function.
     */
    @JvmName("pjtaubadwlaxeoni")
    public suspend fun apiKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param value The name of your Azure Functions app.
     */
    @JvmName("ayqpyqxhaatsigvp")
    public suspend fun functionAppName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionAppName = mapped
    }

    /**
     * @param value The name of the function in your Azure Functions app.
     */
    @JvmName("xucfyqkufectvojn")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value A property that lets you specify the maximum number of events in each batch that's sent to Azure Functions. The default value is 100.
     */
    @JvmName("hfaghwhyvdoumvhe")
    public suspend fun maxBatchCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBatchCount = mapped
    }

    /**
     * @param value A property that lets you set the maximum size for each output batch that's sent to your Azure function. The input unit is in bytes. By default, this value is 262,144 bytes (256 KB).
     */
    @JvmName("cncfosjehbfaekco")
    public suspend fun maxBatchSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBatchSize = mapped
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.AzureFunction'.
     */
    @JvmName("lohghvajnfrsntjc")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureFunctionOutputDataSourceArgs = AzureFunctionOutputDataSourceArgs(
        apiKey = apiKey,
        functionAppName = functionAppName,
        functionName = functionName,
        maxBatchCount = maxBatchCount,
        maxBatchSize = maxBatchSize,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
