@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceOutputColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes an output column for the Azure Machine Learning web service endpoint.
 * @property dataType The (Azure Machine Learning supported) data type of the output column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
 * @property name The name of the output column.
 */
public data class AzureMachineLearningWebServiceOutputColumnArgs(
    public val dataType: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceOutputColumnArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceOutputColumnArgs =
        com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceOutputColumnArgs.builder()
            .dataType(dataType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureMachineLearningWebServiceOutputColumnArgs].
 */
@PulumiTagMarker
public class AzureMachineLearningWebServiceOutputColumnArgsBuilder internal constructor() {
    private var dataType: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The (Azure Machine Learning supported) data type of the output column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
     */
    @JvmName("tbmwrmbimfitmnhd")
    public suspend fun dataType(`value`: Output<String>) {
        this.dataType = value
    }

    /**
     * @param value The name of the output column.
     */
    @JvmName("nrirkbdxbwtasrav")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The (Azure Machine Learning supported) data type of the output column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
     */
    @JvmName("nhfmwgfqyxswexrq")
    public suspend fun dataType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value The name of the output column.
     */
    @JvmName("hlccqlwexadmjgtp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AzureMachineLearningWebServiceOutputColumnArgs =
        AzureMachineLearningWebServiceOutputColumnArgs(
            dataType = dataType,
            name = name,
        )
}
