@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.AzureSqlReferenceInputDataSourceArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.RefreshType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes an Azure SQL database reference input data source.
 * @property database This element is associated with the datasource element. This is the name of the database that output will be written to.
 * @property deltaSnapshotQuery This element is associated with the datasource element. This query is used to fetch incremental changes from the SQL database. To use this option, we recommend using temporal tables in Azure SQL Database.
 * @property fullSnapshotQuery This element is associated with the datasource element. This query is used to fetch data from the sql database.
 * @property password This element is associated with the datasource element. This is the password that will be used to connect to the SQL Database instance.
 * @property refreshRate This element is associated with the datasource element. This indicates how frequently the data will be fetched from the database. It is of DateTime format.
 * @property refreshType Indicates the type of data refresh option.
 * @property server This element is associated with the datasource element. This is the name of the server that contains the database that will be written to.
 * @property table This element is associated with the datasource element. The name of the table in the Azure SQL database..
 * @property type Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Sql/Server/Database'.
 * @property user This element is associated with the datasource element. This is the user name that will be used to connect to the SQL Database instance.
 */
public data class AzureSqlReferenceInputDataSourceArgs(
    public val database: Output<String>? = null,
    public val deltaSnapshotQuery: Output<String>? = null,
    public val fullSnapshotQuery: Output<String>? = null,
    public val password: Output<String>? = null,
    public val refreshRate: Output<String>? = null,
    public val refreshType: Output<Either<String, RefreshType>>? = null,
    public val server: Output<String>? = null,
    public val table: Output<String>? = null,
    public val type: Output<String>,
    public val user: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.AzureSqlReferenceInputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.AzureSqlReferenceInputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.AzureSqlReferenceInputDataSourceArgs.builder()
            .database(database?.applyValue({ args0 -> args0 }))
            .deltaSnapshotQuery(deltaSnapshotQuery?.applyValue({ args0 -> args0 }))
            .fullSnapshotQuery(fullSnapshotQuery?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .refreshRate(refreshRate?.applyValue({ args0 -> args0 }))
            .refreshType(
                refreshType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .server(server?.applyValue({ args0 -> args0 }))
            .table(table?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureSqlReferenceInputDataSourceArgs].
 */
@PulumiTagMarker
public class AzureSqlReferenceInputDataSourceArgsBuilder internal constructor() {
    private var database: Output<String>? = null

    private var deltaSnapshotQuery: Output<String>? = null

    private var fullSnapshotQuery: Output<String>? = null

    private var password: Output<String>? = null

    private var refreshRate: Output<String>? = null

    private var refreshType: Output<Either<String, RefreshType>>? = null

    private var server: Output<String>? = null

    private var table: Output<String>? = null

    private var type: Output<String>? = null

    private var user: Output<String>? = null

    /**
     * @param value This element is associated with the datasource element. This is the name of the database that output will be written to.
     */
    @JvmName("biituholyhtvgnfl")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value This element is associated with the datasource element. This query is used to fetch incremental changes from the SQL database. To use this option, we recommend using temporal tables in Azure SQL Database.
     */
    @JvmName("jpvyxvwiffjnophw")
    public suspend fun deltaSnapshotQuery(`value`: Output<String>) {
        this.deltaSnapshotQuery = value
    }

    /**
     * @param value This element is associated with the datasource element. This query is used to fetch data from the sql database.
     */
    @JvmName("brajtyblhuypujaq")
    public suspend fun fullSnapshotQuery(`value`: Output<String>) {
        this.fullSnapshotQuery = value
    }

    /**
     * @param value This element is associated with the datasource element. This is the password that will be used to connect to the SQL Database instance.
     */
    @JvmName("qsnemgnidttewlhm")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value This element is associated with the datasource element. This indicates how frequently the data will be fetched from the database. It is of DateTime format.
     */
    @JvmName("ofwvhutvlqjvyayd")
    public suspend fun refreshRate(`value`: Output<String>) {
        this.refreshRate = value
    }

    /**
     * @param value Indicates the type of data refresh option.
     */
    @JvmName("navlqeaivsoogemn")
    public suspend fun refreshType(`value`: Output<Either<String, RefreshType>>) {
        this.refreshType = value
    }

    /**
     * @param value This element is associated with the datasource element. This is the name of the server that contains the database that will be written to.
     */
    @JvmName("dmhmfwodyuwtnefb")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value This element is associated with the datasource element. The name of the table in the Azure SQL database..
     */
    @JvmName("mkjwholredgglamt")
    public suspend fun table(`value`: Output<String>) {
        this.table = value
    }

    /**
     * @param value Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Sql/Server/Database'.
     */
    @JvmName("jtasgmyaybtpkdkf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value This element is associated with the datasource element. This is the user name that will be used to connect to the SQL Database instance.
     */
    @JvmName("gcqglqtcthggnurl")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value This element is associated with the datasource element. This is the name of the database that output will be written to.
     */
    @JvmName("tomswlphsouwxkdo")
    public suspend fun database(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value This element is associated with the datasource element. This query is used to fetch incremental changes from the SQL database. To use this option, we recommend using temporal tables in Azure SQL Database.
     */
    @JvmName("tucsqqpvbmllafur")
    public suspend fun deltaSnapshotQuery(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deltaSnapshotQuery = mapped
    }

    /**
     * @param value This element is associated with the datasource element. This query is used to fetch data from the sql database.
     */
    @JvmName("mhixulkaihmmacvw")
    public suspend fun fullSnapshotQuery(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fullSnapshotQuery = mapped
    }

    /**
     * @param value This element is associated with the datasource element. This is the password that will be used to connect to the SQL Database instance.
     */
    @JvmName("njtwqsxxqwnsjtmj")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value This element is associated with the datasource element. This indicates how frequently the data will be fetched from the database. It is of DateTime format.
     */
    @JvmName("dnfaufwjjmugphpd")
    public suspend fun refreshRate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshRate = mapped
    }

    /**
     * @param value Indicates the type of data refresh option.
     */
    @JvmName("dgkedwpjvqwngnmq")
    public suspend fun refreshType(`value`: Either<String, RefreshType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshType = mapped
    }

    /**
     * @param value Indicates the type of data refresh option.
     */
    @JvmName("raeivfxhdqwenhhh")
    public fun refreshType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RefreshType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refreshType = mapped
    }

    /**
     * @param value Indicates the type of data refresh option.
     */
    @JvmName("rcddohiftxicqwmy")
    public fun refreshType(`value`: RefreshType) {
        val toBeMapped = Either.ofRight<String, RefreshType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refreshType = mapped
    }

    /**
     * @param value This element is associated with the datasource element. This is the name of the server that contains the database that will be written to.
     */
    @JvmName("lwakqmxodacqnfbo")
    public suspend fun server(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value This element is associated with the datasource element. The name of the table in the Azure SQL database..
     */
    @JvmName("hhmrucbjmrpnrmhc")
    public suspend fun table(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.table = mapped
    }

    /**
     * @param value Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Sql/Server/Database'.
     */
    @JvmName("whsfnxbkijusvaoe")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value This element is associated with the datasource element. This is the user name that will be used to connect to the SQL Database instance.
     */
    @JvmName("ossajikbxhqvqmka")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): AzureSqlReferenceInputDataSourceArgs = AzureSqlReferenceInputDataSourceArgs(
        database = database,
        deltaSnapshotQuery = deltaSnapshotQuery,
        fullSnapshotQuery = fullSnapshotQuery,
        password = password,
        refreshRate = refreshRate,
        refreshType = refreshType,
        server = server,
        table = table,
        type = type ?: throw PulumiNullFieldException("type"),
        user = user,
    )
}
