@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.AzureTableOutputDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes an Azure Table output data source.
 * @property accountKey The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
 * @property accountName The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
 * @property batchSize The number of rows to write to the Azure Table at a time.
 * @property columnsToRemove If specified, each item in the array is the name of a column to remove (if present) from output event entities.
 * @property partitionKey This element indicates the name of a column from the SELECT statement in the query that will be used as the partition key for the Azure Table. Required on PUT (CreateOrReplace) requests.
 * @property rowKey This element indicates the name of a column from the SELECT statement in the query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace) requests.
 * @property table The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Storage/Table'.
 */
public data class AzureTableOutputDataSourceArgs(
    public val accountKey: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val batchSize: Output<Int>? = null,
    public val columnsToRemove: Output<List<String>>? = null,
    public val partitionKey: Output<String>? = null,
    public val rowKey: Output<String>? = null,
    public val table: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.AzureTableOutputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.AzureTableOutputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.AzureTableOutputDataSourceArgs.builder()
            .accountKey(accountKey?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .columnsToRemove(columnsToRemove?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .partitionKey(partitionKey?.applyValue({ args0 -> args0 }))
            .rowKey(rowKey?.applyValue({ args0 -> args0 }))
            .table(table?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureTableOutputDataSourceArgs].
 */
@PulumiTagMarker
public class AzureTableOutputDataSourceArgsBuilder internal constructor() {
    private var accountKey: Output<String>? = null

    private var accountName: Output<String>? = null

    private var batchSize: Output<Int>? = null

    private var columnsToRemove: Output<List<String>>? = null

    private var partitionKey: Output<String>? = null

    private var rowKey: Output<String>? = null

    private var table: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("qjfivtnfiigwupwp")
    public suspend fun accountKey(`value`: Output<String>) {
        this.accountKey = value
    }

    /**
     * @param value The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("kjpogkuutvhsneih")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The number of rows to write to the Azure Table at a time.
     */
    @JvmName("khqjqgvpyqpgayty")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value If specified, each item in the array is the name of a column to remove (if present) from output event entities.
     */
    @JvmName("nalorubjxwmvvjkn")
    public suspend fun columnsToRemove(`value`: Output<List<String>>) {
        this.columnsToRemove = value
    }

    @JvmName("rbvgaiwvjiaparti")
    public suspend fun columnsToRemove(vararg values: Output<String>) {
        this.columnsToRemove = Output.all(values.asList())
    }

    /**
     * @param values If specified, each item in the array is the name of a column to remove (if present) from output event entities.
     */
    @JvmName("jkmbitsisatkynqi")
    public suspend fun columnsToRemove(values: List<Output<String>>) {
        this.columnsToRemove = Output.all(values)
    }

    /**
     * @param value This element indicates the name of a column from the SELECT statement in the query that will be used as the partition key for the Azure Table. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("hgigarkrovhgcdsv")
    public suspend fun partitionKey(`value`: Output<String>) {
        this.partitionKey = value
    }

    /**
     * @param value This element indicates the name of a column from the SELECT statement in the query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("utnfsbdjrksaewqo")
    public suspend fun rowKey(`value`: Output<String>) {
        this.rowKey = value
    }

    /**
     * @param value The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("bmkoxvhtoebtsldg")
    public suspend fun table(`value`: Output<String>) {
        this.table = value
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Storage/Table'.
     */
    @JvmName("cnpxdpgwthknvefh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("gplskreuaqincgep")
    public suspend fun accountKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("alsujkgrjxngaplg")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The number of rows to write to the Azure Table at a time.
     */
    @JvmName("uhudpijkshqnerac")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value If specified, each item in the array is the name of a column to remove (if present) from output event entities.
     */
    @JvmName("xaevfoxroatbhvue")
    public suspend fun columnsToRemove(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnsToRemove = mapped
    }

    /**
     * @param values If specified, each item in the array is the name of a column to remove (if present) from output event entities.
     */
    @JvmName("kiwsasypckrqddbi")
    public suspend fun columnsToRemove(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnsToRemove = mapped
    }

    /**
     * @param value This element indicates the name of a column from the SELECT statement in the query that will be used as the partition key for the Azure Table. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("fxnsupvpdoyssvqw")
    public suspend fun partitionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKey = mapped
    }

    /**
     * @param value This element indicates the name of a column from the SELECT statement in the query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("swvyeifnhvoomeql")
    public suspend fun rowKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rowKey = mapped
    }

    /**
     * @param value The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("bpxsqnmnjowkgrfd")
    public suspend fun table(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.table = mapped
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Storage/Table'.
     */
    @JvmName("xebqcwfufaelvbeq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureTableOutputDataSourceArgs = AzureTableOutputDataSourceArgs(
        accountKey = accountKey,
        accountName = accountName,
        batchSize = batchSize,
        columnsToRemove = columnsToRemove,
        partitionKey = partitionKey,
        rowKey = rowKey,
        table = table,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
