@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.CsvSerializationArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.Encoding
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes how data from an input is serialized or how data is serialized when written to an output in CSV format.
 * @property encoding Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
 * @property fieldDelimiter Specifies the delimiter that will be used to separate comma-separated value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of supported values. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Csv'.
 */
public data class CsvSerializationArgs(
    public val encoding: Output<Either<String, Encoding>>? = null,
    public val fieldDelimiter: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.CsvSerializationArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.CsvSerializationArgs =
        com.pulumi.azurenative.streamanalytics.inputs.CsvSerializationArgs.builder()
            .encoding(
                encoding?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .fieldDelimiter(fieldDelimiter?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CsvSerializationArgs].
 */
@PulumiTagMarker
public class CsvSerializationArgsBuilder internal constructor() {
    private var encoding: Output<Either<String, Encoding>>? = null

    private var fieldDelimiter: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("kkbrrpvcbtagydns")
    public suspend fun encoding(`value`: Output<Either<String, Encoding>>) {
        this.encoding = value
    }

    /**
     * @param value Specifies the delimiter that will be used to separate comma-separated value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of supported values. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("wrhrwmoavhkrlkgf")
    public suspend fun fieldDelimiter(`value`: Output<String>) {
        this.fieldDelimiter = value
    }

    /**
     * @param value Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Csv'.
     */
    @JvmName("bkfdegnxxqqpqejx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("kfhpvripyrhxubdt")
    public suspend fun encoding(`value`: Either<String, Encoding>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("jyuodgajvcmiqptc")
    public fun encoding(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Encoding>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("mqaqmkpughakctkh")
    public fun encoding(`value`: Encoding) {
        val toBeMapped = Either.ofRight<String, Encoding>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value Specifies the delimiter that will be used to separate comma-separated value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of supported values. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("tprnauburnxjewtg")
    public suspend fun fieldDelimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldDelimiter = mapped
    }

    /**
     * @param value Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Csv'.
     */
    @JvmName("ryjuncqcmsfxsqfs")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CsvSerializationArgs = CsvSerializationArgs(
        encoding = encoding,
        fieldDelimiter = fieldDelimiter,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
