@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.DocumentDbOutputDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a DocumentDB output data source.
 * @property accountId The DocumentDB account name or ID. Required on PUT (CreateOrReplace) requests.
 * @property accountKey The account key for the DocumentDB account. Required on PUT (CreateOrReplace) requests.
 * @property collectionNamePattern The collection name pattern for the collections to be used. The collection name format can be constructed using the optional {partition} token, where partitions start from 0. See the DocumentDB section of https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more information. Required on PUT (CreateOrReplace) requests.
 * @property database The name of the DocumentDB database. Required on PUT (CreateOrReplace) requests.
 * @property documentId The name of the field in output events used to specify the primary key which insert or update operations are based on.
 * @property partitionKey The name of the field in output events used to specify the key for partitioning output across collections. If 'collectionNamePattern' contains the {partition} token, this property is required to be specified.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Storage/DocumentDB'.
 */
public data class DocumentDbOutputDataSourceArgs(
    public val accountId: Output<String>? = null,
    public val accountKey: Output<String>? = null,
    public val collectionNamePattern: Output<String>? = null,
    public val database: Output<String>? = null,
    public val documentId: Output<String>? = null,
    public val partitionKey: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.DocumentDbOutputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.DocumentDbOutputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.DocumentDbOutputDataSourceArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .accountKey(accountKey?.applyValue({ args0 -> args0 }))
            .collectionNamePattern(collectionNamePattern?.applyValue({ args0 -> args0 }))
            .database(database?.applyValue({ args0 -> args0 }))
            .documentId(documentId?.applyValue({ args0 -> args0 }))
            .partitionKey(partitionKey?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DocumentDbOutputDataSourceArgs].
 */
@PulumiTagMarker
public class DocumentDbOutputDataSourceArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var accountKey: Output<String>? = null

    private var collectionNamePattern: Output<String>? = null

    private var database: Output<String>? = null

    private var documentId: Output<String>? = null

    private var partitionKey: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The DocumentDB account name or ID. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("sqxgivajpdmfrngu")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The account key for the DocumentDB account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("yrhvjednndqsemed")
    public suspend fun accountKey(`value`: Output<String>) {
        this.accountKey = value
    }

    /**
     * @param value The collection name pattern for the collections to be used. The collection name format can be constructed using the optional {partition} token, where partitions start from 0. See the DocumentDB section of https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more information. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("rnvichfsyfslhqml")
    public suspend fun collectionNamePattern(`value`: Output<String>) {
        this.collectionNamePattern = value
    }

    /**
     * @param value The name of the DocumentDB database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("lapbmemlrichnpla")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The name of the field in output events used to specify the primary key which insert or update operations are based on.
     */
    @JvmName("jtemhtbxlrwwotoh")
    public suspend fun documentId(`value`: Output<String>) {
        this.documentId = value
    }

    /**
     * @param value The name of the field in output events used to specify the key for partitioning output across collections. If 'collectionNamePattern' contains the {partition} token, this property is required to be specified.
     */
    @JvmName("tlndbuojiebbvwkw")
    public suspend fun partitionKey(`value`: Output<String>) {
        this.partitionKey = value
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Storage/DocumentDB'.
     */
    @JvmName("aabdncaxiqyafmmv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The DocumentDB account name or ID. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("dyhobiscjobdxvrv")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The account key for the DocumentDB account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("pphnfrejpjlsocip")
    public suspend fun accountKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value The collection name pattern for the collections to be used. The collection name format can be constructed using the optional {partition} token, where partitions start from 0. See the DocumentDB section of https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more information. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("xcciijckfbpqogdp")
    public suspend fun collectionNamePattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectionNamePattern = mapped
    }

    /**
     * @param value The name of the DocumentDB database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("lvpkafmjgrgjwfyn")
    public suspend fun database(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The name of the field in output events used to specify the primary key which insert or update operations are based on.
     */
    @JvmName("fpwqhnfhoruhvlqy")
    public suspend fun documentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentId = mapped
    }

    /**
     * @param value The name of the field in output events used to specify the key for partitioning output across collections. If 'collectionNamePattern' contains the {partition} token, this property is required to be specified.
     */
    @JvmName("mbhijecuuixikkpq")
    public suspend fun partitionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKey = mapped
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Storage/DocumentDB'.
     */
    @JvmName("qamhrwcympporxbv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DocumentDbOutputDataSourceArgs = DocumentDbOutputDataSourceArgs(
        accountId = accountId,
        accountKey = accountKey,
        collectionNamePattern = collectionNamePattern,
        database = database,
        documentId = documentId,
        partitionKey = partitionKey,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
